/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import lombok.Generated;
import org.vaadin.stefan.fullcalendar.FullCalendar;
import org.vaadin.stefan.fullcalendar.JsonUtils;
import org.vaadin.stefan.fullcalendar.Timezone;

public abstract class DateTimeEvent
extends ComponentEvent<FullCalendar> {
    private final boolean allDay;
    private final LocalDateTime dateTime;

    public DateTimeEvent(FullCalendar source, boolean fromClient, String dateString, boolean allDay) {
        super((Component)source, fromClient);
        this.allDay = allDay;
        this.dateTime = JsonUtils.parseClientSideDateTime(dateString);
    }

    public Instant getDateTimeAsInstant() {
        return Timezone.UTC.convertToInstant(this.dateTime);
    }

    public LocalDateTime getDateTimeWithOffset() {
        return this.isAllDay() ? this.dateTime : ((FullCalendar)this.getSource()).getTimezone().applyTimezoneOffset(this.dateTime);
    }

    public LocalDate getDate() {
        return this.dateTime.toLocalDate();
    }

    @Generated
    public boolean isAllDay() {
        return this.allDay;
    }

    @Generated
    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    @Generated
    public String toString() {
        return "DateTimeEvent(allDay=" + this.isAllDay() + ", dateTime=" + String.valueOf(this.getDateTime()) + ")";
    }
}

