/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar;

import com.vaadin.flow.data.binder.Setter;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.vaadin.stefan.fullcalendar.converters.JsonItemPropertyConverter;
import org.vaadin.stefan.fullcalendar.json.JsonConverter;
import org.vaadin.stefan.fullcalendar.json.JsonIgnore;
import org.vaadin.stefan.fullcalendar.json.JsonName;
import org.vaadin.stefan.fullcalendar.json.JsonUpdateAllowed;

public class BeanProperties<T> {
    private final Field field;
    private final ValueProvider<T, Object> getter;
    private final Setter<T, Object> setter;
    private final boolean jsonIgnored;
    private final boolean jsonUpdateAllowed;
    private final String jsonName;
    private final JsonItemPropertyConverter<?, ?> converter;

    private BeanProperties(Field field, ValueProvider<T, Object> getter, Setter<T, Object> setter) {
        this.field = field;
        this.getter = getter;
        this.setter = setter;
        this.jsonIgnored = field.getAnnotation(JsonIgnore.class) != null;
        this.jsonUpdateAllowed = field.getAnnotation(JsonUpdateAllowed.class) != null;
        JsonName nameAnnotation = field.getAnnotation(JsonName.class);
        this.jsonName = nameAnnotation != null ? nameAnnotation.value() : field.getName();
        JsonConverter converterAnnotation = field.getAnnotation(JsonConverter.class);
        if (converterAnnotation != null) {
            try {
                this.converter = converterAnnotation.value().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Failed to instantiate converter for field " + field.getName(), e);
            }
        } else {
            this.converter = null;
        }
    }

    public static <T> Set<BeanProperties<T>> read(Class<T> type) {
        return Stream.of(type.getDeclaredFields()).map(field -> {
            String fieldName = field.getName();
            Method getterMethod = MethodUtils.getAccessibleMethod((Class)type, (String)("get" + StringUtils.capitalize((String)fieldName)), (Class[])new Class[0]);
            if (getterMethod == null) {
                getterMethod = MethodUtils.getAccessibleMethod((Class)type, (String)("is" + StringUtils.capitalize((String)fieldName)), (Class[])new Class[0]);
            }
            if (getterMethod == null) {
                getterMethod = MethodUtils.getAccessibleMethod((Class)type, (String)fieldName, (Class[])new Class[0]);
            }
            if (getterMethod == null) {
                return null;
            }
            Class<?> fieldType = field.getType();
            Method setterMethod = MethodUtils.getAccessibleMethod((Class)type, (String)("set" + StringUtils.capitalize((String)fieldName)), (Class[])new Class[]{fieldType});
            if (setterMethod == null) {
                setterMethod = MethodUtils.getAccessibleMethod((Class)type, (String)fieldName, (Class[])new Class[]{fieldType});
            }
            Method finalGetterMethod = getterMethod;
            Method finalSetterMethod = setterMethod;
            ValueProvider & Serializable getter = (ValueProvider & Serializable)item -> {
                try {
                    return finalGetterMethod.invoke(item, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException("Failed to invoke getter for field " + fieldName, e);
                }
            };
            Setter & Serializable setter = finalSetterMethod != null ? (Setter & Serializable)(item, value) -> {
                Object valueToWrite = value;
                if (value instanceof Optional) {
                    valueToWrite = ((Optional)value).orElse(null);
                }
                try {
                    finalSetterMethod.invoke(item, valueToWrite);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException("Failed to invoke setter for field " + fieldName, e);
                }
            } : null;
            return new BeanProperties((Field)field, getter, setter);
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Optional<Setter<T, Object>> getSetter() {
        return Optional.ofNullable(this.setter);
    }

    public String getName() {
        return this.field.getName();
    }

    public boolean isJsonIgnored() {
        return this.jsonIgnored;
    }

    public boolean isJsonUpdateAllowed() {
        return this.jsonUpdateAllowed;
    }

    public String getJsonName() {
        return this.jsonName;
    }

    public <V, E> JsonItemPropertyConverter<V, E> getConverter() {
        return this.converter;
    }

    @Generated
    public Field getField() {
        return this.field;
    }

    @Generated
    public ValueProvider<T, Object> getGetter() {
        return this.getter;
    }
}

