/*
 * Copyright 2020, Stefan Uebe
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package org.vaadin.stefan.fullcalendar;


import java.util.Optional;

/**
 * Marks a class as a client side setting, which returns client side representation for an instance of this class.
 * An enumeration for instance would return a client side parseable version of the server side enum instance,
 * e.g. RenderingMode.INVERSE_BACKGROUND.getClientSideName() // returns "inverse-background"
 */
public interface ClientSideValue {
    /**
     * Returns a client side representation of this instance.
     *
     * @return String
     */
    String getClientSideValue();

    static <T extends ClientSideValue> Optional<T> ofClientSideValue(String clientSideValue, Class<T> targetType) {
        for (T value : targetType.getEnumConstants()) {
            if (value.getClientSideValue().equals(clientSideValue)) {
                return Optional.of(value);
            }
        }

        return Optional.empty();
    }
}
