/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar.model;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.vaadin.stefan.fullcalendar.JsonFactory;
import org.vaadin.stefan.fullcalendar.JsonUtils;
import org.vaadin.stefan.fullcalendar.model.HeaderFooterItem;
import org.vaadin.stefan.fullcalendar.model.HeaderFooterPartPosition;
import tools.jackson.databind.node.ObjectNode;

public class HeaderFooterPart {
    private final HeaderFooterPartPosition position;
    private final LinkedHashSet<HeaderFooterItem> items;

    public HeaderFooterPart(HeaderFooterPartPosition position) {
        this(position, null);
    }

    public HeaderFooterPart(HeaderFooterPartPosition position, Collection<HeaderFooterItem> items) {
        this.position = Objects.requireNonNull(position);
        this.items = items != null ? new LinkedHashSet<HeaderFooterItem>(items) : new LinkedHashSet();
    }

    public void addItem(HeaderFooterItem item) {
        this.items.add(Objects.requireNonNull(item));
    }

    public void removeItem(HeaderFooterItem item) {
        this.items.remove((Object)item);
    }

    public void removeItems() {
        this.items.clear();
    }

    public HeaderFooterPartPosition getPosition() {
        return this.position;
    }

    public Set<HeaderFooterItem> getItems() {
        return Collections.unmodifiableSet(this.items);
    }

    protected ObjectNode toJson() {
        ObjectNode jsonObject = JsonFactory.createObject();
        jsonObject.set(this.position.getCode(), JsonUtils.toJsonNode(this.items.stream().map(HeaderFooterItem::getCode)));
        return jsonObject;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HeaderFooterPart)) {
            return false;
        }
        HeaderFooterPart other = (HeaderFooterPart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HeaderFooterPartPosition this$position = this.getPosition();
        HeaderFooterPartPosition other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)((Object)this$position)).equals((Object)other$position)) {
            return false;
        }
        Set<HeaderFooterItem> this$items = this.getItems();
        Set<HeaderFooterItem> other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HeaderFooterPart;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HeaderFooterPartPosition $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)((Object)$position)).hashCode());
        Set<HeaderFooterItem> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HeaderFooterPart(position=" + String.valueOf((Object)this.getPosition()) + ", items=" + String.valueOf(this.getItems()) + ")";
    }
}

