/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar.dataprovider;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import lombok.NonNull;
import org.vaadin.stefan.fullcalendar.Entry;
import org.vaadin.stefan.fullcalendar.FullCalendar;
import org.vaadin.stefan.fullcalendar.Timezone;
import org.vaadin.stefan.fullcalendar.dataprovider.AbstractEntryProvider;
import org.vaadin.stefan.fullcalendar.dataprovider.EntryProvider;
import org.vaadin.stefan.fullcalendar.dataprovider.EntryQuery;

public class InMemoryEntryProvider<T extends Entry>
extends AbstractEntryProvider<T>
implements EntryProvider<T> {
    private final Map<String, T> entriesMap = new HashMap<String, T>();

    public InMemoryEntryProvider() {
    }

    public InMemoryEntryProvider(Iterable<T> entries) {
        this.addEntries(entries);
    }

    @SafeVarargs
    public static <T extends Entry> InMemoryEntryProvider<T> from(T ... entries) {
        return new InMemoryEntryProvider<T>(Arrays.asList(entries));
    }

    public static <T extends Entry> InMemoryEntryProvider<T> from(Iterable<T> entries) {
        return new InMemoryEntryProvider<T>(entries);
    }

    @Override
    public void setCalendar(FullCalendar calendar) {
        FullCalendar oldCalendar = this.getCalendar();
        super.setCalendar(calendar);
        if (oldCalendar != calendar) {
            this.entriesMap.values().forEach(e -> e.setCalendar(calendar));
        }
    }

    @Override
    public Stream<T> fetch(@NonNull EntryQuery query) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        return query.applyFilter(this.entriesMap.values().stream());
    }

    @Override
    public Optional<T> fetchById(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return Optional.ofNullable((Entry)this.entriesMap.get(id));
    }

    public void addEntries(Iterable<T> iterableEntries) {
        Objects.requireNonNull(iterableEntries);
        iterableEntries.forEach(entry -> {
            String id = entry.getId();
            if (!this.entriesMap.containsKey(id)) {
                this.entriesMap.put(id, entry);
                entry.setCalendar(this.getCalendar());
                this.onEntryAdd(entry);
            }
        });
    }

    protected void onEntryAdd(T entry) {
    }

    public void removeEntries(Iterable<T> iterableEntries) {
        Objects.requireNonNull(iterableEntries);
        iterableEntries.forEach(entry -> {
            String id = entry.getId();
            if (this.entriesMap.remove(id) != null) {
                entry.setCalendar(null);
                this.onEntryRemove(entry);
            }
        });
    }

    protected void onEntryRemove(T entry) {
    }

    public void updateEntries(Iterable<T> iterableEntries) {
        Objects.requireNonNull(iterableEntries);
        Map entriesMap = this.getEntriesMap();
        StreamSupport.stream(iterableEntries.spliterator(), true).filter(entry -> entriesMap.containsKey(entry.getId()) && entry.isKnownToTheClient()).forEach(this::onEntryUpdate);
    }

    public void onEntryUpdate(T entry) {
    }

    public Optional<T> getEntryById(String id) {
        return this.fetchById(id);
    }

    public List<T> getEntries() {
        return this.fetchAll().collect(Collectors.toList());
    }

    public List<T> getEntries(LocalDateTime filterStart, LocalDateTime filterEnd) {
        return this.fetch(new EntryQuery(filterStart, filterEnd)).collect(Collectors.toList());
    }

    public List<T> getEntries(Instant filterStart, Instant filterEnd) {
        return this.getEntries(Timezone.UTC.convertToLocalDateTime(filterStart), Timezone.UTC.convertToLocalDateTime(filterEnd));
    }

    public List<T> getEntries(Instant dateTime) {
        return this.getEntries(Timezone.UTC.convertToLocalDateTime(dateTime));
    }

    public List<T> getEntries(LocalDate date) {
        Objects.requireNonNull(date);
        return this.getEntries(date.atStartOfDay());
    }

    public List<T> getEntries(LocalDateTime dateTime) {
        Objects.requireNonNull(dateTime);
        return this.getEntries(dateTime, dateTime.plusDays(1L));
    }

    public void addEntry(T entry) {
        Objects.requireNonNull(entry);
        this.addEntries((Iterable<T>)Collections.singletonList(entry));
    }

    public void addEntries(T ... arrayOfEntries) {
        this.addEntries((Iterable<T>)Arrays.asList(arrayOfEntries));
    }

    public void removeEntry(T entry) {
        Objects.requireNonNull(entry);
        this.removeEntries((Iterable<T>)Collections.singletonList(entry));
    }

    public void removeEntries(T ... arrayOfEntries) {
        this.removeEntries((Iterable<T>)Arrays.asList(arrayOfEntries));
    }

    public void removeAllEntries() {
        this.removeEntries(this.fetchAll().collect(Collectors.toList()));
    }

    @Generated
    protected Map<String, T> getEntriesMap() {
        return this.entriesMap;
    }
}

