/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;

public enum CalendarLocale {
    AFRIKAANS("af"),
    ARABIC("ar"),
    ARABIC_ALGERIA("ar-dz"),
    ARABIC_KUWAIT("ar-kw"),
    ARABIC_LYBIA("ar-ly"),
    ARABIC_MOROCCO("ar-ma"),
    ARABIC_SAUDI_ARABIA("ar-sa"),
    ARABIC_TUNESIA("ar-tn"),
    BULGARIAN("bg"),
    BOSNIAN("bs"),
    CATALAN("ca"),
    CZECH("cs"),
    DANISH("da"),
    GERMAN("de"),
    GERMAN_GERMANY("de-de"),
    GERMAN_AUSTRIA("de-at"),
    GERMAN_SWITZERLAND("de-ch"),
    GREEK("el"),
    ENGLISH("en"),
    ENGLISH_AUSTRALIA("en-au"),
    ENGLISH_CANADA("en-ca"),
    ENGLISH_UK("en-gb"),
    ENGLISH_IRELAND("en-ie"),
    ENGLISH_NEW_ZEALAND("en-nz"),
    SPANISH("es"),
    SPANICH_DOMINICAN_REPUBLIC("es-do"),
    SPANISH_US("es-us"),
    ESTONIAN("et"),
    BASQUE("eu"),
    PERSIAN("fa"),
    FINNISH("fi"),
    FRENCH("fr"),
    FRENCH_CANADA("fr-ca"),
    FRENCH_SWITZERLAND("fr-ch"),
    GALICIAN("gl"),
    HEBREW("he"),
    HINDI("hi"),
    CROATIAN("hr"),
    HUNGARIAN("hu"),
    INDONESIAN("id"),
    ICELANDIC("is"),
    ITALIAN("it"),
    JAPANESE("ja"),
    GEORGIAN("ka"),
    KAZAKH("kk"),
    KOREAN("ko"),
    LUXEMBOURGISH("lb"),
    LITHUNIAN("lt"),
    LATVIAN("lv"),
    MACEDONIAN("mk"),
    MALAY("ms"),
    MALAYSIA("ms-my"),
    NORWEGIAN_BOKMAL("nb"),
    DUTCH("nl"),
    DUTCH_BELGIUM("nl-be"),
    NORWEGIAN_NYNORSK("nn"),
    POLISH("pl"),
    PORTUGUESE("pt"),
    PORTUGUESE_BRAZIL("pt-br"),
    ROMANIAN("ro"),
    RUSSIAN("ru"),
    SLOVAK("sk"),
    SLOVENIAN("sl"),
    ALBANIAN("sq"),
    SERBIAN("sr"),
    SERBIAN_CYRILLIC("sr-cyrl"),
    SWEDISH("sv"),
    THAI("th"),
    TURKISH("tr"),
    UKRAINIAN("uk"),
    VIETNAMESE("vi"),
    CHINESE("zh-cn"),
    CHINESE_TAIWAN("zh-tw");

    private static final Locale[] availableLocales;
    private static CalendarLocale defaultLocale;
    private final Locale locale;

    private CalendarLocale(String languageTag) {
        this.locale = Objects.requireNonNull(Locale.forLanguageTag(languageTag), "Could not interprete language tag " + languageTag);
    }

    public static Optional<CalendarLocale> valueOf(Locale locale) {
        for (CalendarLocale calendarLocale : CalendarLocale.values()) {
            if (!calendarLocale.getLocale().equals(locale)) continue;
            return Optional.of(calendarLocale);
        }
        return Optional.empty();
    }

    public static Locale[] getAvailableLocales() {
        return Arrays.copyOf(availableLocales, availableLocales.length);
    }

    public static Locale getDefaultLocale() {
        return defaultLocale.getLocale();
    }

    public static void setDefault(CalendarLocale locale) {
        defaultLocale = Objects.requireNonNull(locale, "Parameter must not be null");
    }

    @Generated
    public Locale getLocale() {
        return this.locale;
    }

    static {
        availableLocales = (Locale[])Stream.of(CalendarLocale.values()).map(CalendarLocale::getLocale).toArray(Locale[]::new);
        defaultLocale = CalendarLocale.valueOf(Locale.getDefault()).orElse(ENGLISH);
    }
}

