/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar.converters;

import java.time.LocalTime;
import lombok.Generated;
import org.vaadin.stefan.fullcalendar.Entry;
import org.vaadin.stefan.fullcalendar.JsonUtils;
import org.vaadin.stefan.fullcalendar.converters.JsonItemPropertyConverter;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.NullNode;
import tools.jackson.databind.node.StringNode;

public class LocalTimeConverter<T extends Entry>
implements JsonItemPropertyConverter<LocalTime, T> {
    @Override
    public boolean supports(Object type) {
        return type == null || type instanceof LocalTime;
    }

    @Override
    public JsonNode toClientModel(LocalTime serverValue, T currentInstance) {
        return JsonUtils.toJsonNode(JsonUtils.formatClientSideTimeString(serverValue));
    }

    @Override
    public LocalTime toServerModel(JsonNode clientValue, T currentInstance) {
        if (clientValue instanceof NullNode) {
            return null;
        }
        if (clientValue instanceof StringNode) {
            return JsonUtils.parseClientSideTime(clientValue.asString());
        }
        throw new IllegalArgumentException(String.valueOf(clientValue) + " must either be of type NullNode or StringNode, but was " + String.valueOf(clientValue != null ? clientValue.getClass() : null) + ": " + String.valueOf(clientValue));
    }

    @Generated
    public LocalTimeConverter() {
    }
}

