/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import lombok.Generated;
import org.vaadin.stefan.fullcalendar.ClientSideValue;

public class Timezone
implements ClientSideValue {
    public static final ZoneId ZONE_ID_UTC = ZoneId.of("UTC");
    public static final Timezone UTC = new Timezone(ZONE_ID_UTC, "UTC");
    private static final Timezone[] AVAILABLE_ZONES;
    private final String clientSideValue;
    private final ZoneId zoneId;

    public static Timezone[] getAvailableZones() {
        return AVAILABLE_ZONES;
    }

    public Timezone(ZoneId zoneId) {
        this(zoneId, zoneId.getId());
    }

    public Timezone(ZoneId zoneId, String clientSideValue) {
        Objects.requireNonNull(zoneId);
        this.clientSideValue = clientSideValue;
        this.zoneId = zoneId;
    }

    public static Timezone getSystem() {
        return new Timezone(ZoneId.systemDefault());
    }

    @Override
    public String getClientSideValue() {
        return this.clientSideValue;
    }

    public ZonedDateTime applyTimezone(LocalDateTime localDateTime) {
        return localDateTime != null ? ZonedDateTime.of(localDateTime, ZONE_ID_UTC).withZoneSameInstant(this.getZoneId()) : null;
    }

    public ZonedDateTime removeTimezone(LocalDateTime localDateTime) {
        return localDateTime != null ? ZonedDateTime.of(localDateTime, this.getZoneId()).withZoneSameInstant(ZONE_ID_UTC) : null;
    }

    public LocalDateTime applyTimezoneOffset(LocalDateTime localDateTime) {
        return localDateTime != null ? this.applyTimezone(localDateTime).toLocalDateTime() : null;
    }

    public LocalDateTime removeTimezoneOffset(LocalDateTime localDateTime) {
        return localDateTime != null ? this.removeTimezone(localDateTime).toLocalDateTime() : null;
    }

    public ZonedDateTime asZonedDateTime(LocalDateTime localDateTime) {
        return localDateTime != null ? ZonedDateTime.of(localDateTime, this.getZoneId()) : null;
    }

    public Instant convertToInstant(LocalDate date) {
        if (date == null) {
            return null;
        }
        LocalDateTime dateTime = date.atStartOfDay();
        return this.convertToInstant(dateTime);
    }

    public Instant convertToInstant(LocalDateTime dateTime) {
        return dateTime != null ? dateTime.toInstant(this.getZoneId().getRules().getOffset(dateTime)) : null;
    }

    public LocalDateTime convertToLocalDateTime(Instant instant) {
        return instant != null ? LocalDateTime.ofInstant(instant, this.getZoneId()) : null;
    }

    public LocalDate convertToLocalDate(Instant instant) {
        return instant != null ? this.convertToLocalDateTime(instant).toLocalDate() : null;
    }

    public String toString() {
        return "Timezone{clientSideValue='" + this.clientSideValue + "', zoneId=" + String.valueOf(this.zoneId) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Timezone timezone = (Timezone)o;
        return Objects.equals(this.clientSideValue, timezone.clientSideValue);
    }

    public int hashCode() {
        return Objects.hash(this.clientSideValue);
    }

    @Generated
    public ZoneId getZoneId() {
        return this.zoneId;
    }

    static {
        Timezone[] timezones = (Timezone[])ZoneId.getAvailableZoneIds().stream().sorted().filter(s -> !s.equalsIgnoreCase("utc")).map(ZoneId::of).map(Timezone::new).toArray(Timezone[]::new);
        ArrayList<Timezone> timezonesList = new ArrayList<Timezone>(Collections.singletonList(UTC));
        timezonesList.addAll(Arrays.asList(timezones));
        AVAILABLE_ZONES = timezonesList.toArray(new Timezone[0]);
    }

    public static class TimezoneNotFoundException
    extends RuntimeException {
        public TimezoneNotFoundException(String message) {
            super(message);
        }

        public TimezoneNotFoundException(String message, Throwable cause) {
            super(message, cause);
        }

        public TimezoneNotFoundException(Throwable cause) {
            super(cause);
        }
    }
}

