/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.CaseUtils;
import org.vaadin.stefan.fullcalendar.BrowserTimezoneObtainedEvent;
import org.vaadin.stefan.fullcalendar.BusinessHours;
import org.vaadin.stefan.fullcalendar.CalendarLocale;
import org.vaadin.stefan.fullcalendar.CalendarView;
import org.vaadin.stefan.fullcalendar.CalendarViewImpl;
import org.vaadin.stefan.fullcalendar.ClientSideValue;
import org.vaadin.stefan.fullcalendar.CustomCalendarView;
import org.vaadin.stefan.fullcalendar.DatesRenderedEvent;
import org.vaadin.stefan.fullcalendar.DayNumberClickedEvent;
import org.vaadin.stefan.fullcalendar.DisplayMode;
import org.vaadin.stefan.fullcalendar.Entry;
import org.vaadin.stefan.fullcalendar.EntryClickedEvent;
import org.vaadin.stefan.fullcalendar.EntryDroppedEvent;
import org.vaadin.stefan.fullcalendar.EntryMouseEnterEvent;
import org.vaadin.stefan.fullcalendar.EntryMouseLeaveEvent;
import org.vaadin.stefan.fullcalendar.EntryResizedEvent;
import org.vaadin.stefan.fullcalendar.FullCalendarVariant;
import org.vaadin.stefan.fullcalendar.JsonFactory;
import org.vaadin.stefan.fullcalendar.JsonUtils;
import org.vaadin.stefan.fullcalendar.MoreLinkClickedEvent;
import org.vaadin.stefan.fullcalendar.TimeslotClickedEvent;
import org.vaadin.stefan.fullcalendar.TimeslotsSelectedEvent;
import org.vaadin.stefan.fullcalendar.Timezone;
import org.vaadin.stefan.fullcalendar.ViewSkeletonRenderedEvent;
import org.vaadin.stefan.fullcalendar.WeekNumberClickedEvent;
import org.vaadin.stefan.fullcalendar.dataprovider.EntryProvider;
import org.vaadin.stefan.fullcalendar.dataprovider.EntryQuery;
import org.vaadin.stefan.fullcalendar.dataprovider.InMemoryEntryProvider;
import org.vaadin.stefan.fullcalendar.model.Footer;
import org.vaadin.stefan.fullcalendar.model.Header;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.ObjectNode;

@NpmPackage.Container(value={@NpmPackage(value="@fullcalendar/core", version="6.1.19"), @NpmPackage(value="@fullcalendar/interaction", version="6.1.19"), @NpmPackage(value="@fullcalendar/daygrid", version="6.1.19"), @NpmPackage(value="@fullcalendar/timegrid", version="6.1.19"), @NpmPackage(value="@fullcalendar/list", version="6.1.19"), @NpmPackage(value="@fullcalendar/multimonth", version="6.1.19"), @NpmPackage(value="moment", version="2.30.1"), @NpmPackage(value="moment-timezone", version="0.6.0"), @NpmPackage(value="@fullcalendar/moment", version="6.1.19"), @NpmPackage(value="@fullcalendar/moment-timezone", version="6.1.19")})
@JsModule(value="./vaadin-full-calendar/full-calendar.ts")
@CssImport(value="./vaadin-full-calendar/full-calendar-styles.css")
@Tag(value="vaadin-full-calendar")
public class FullCalendar
extends Component
implements HasStyle,
HasSize,
HasTheme {
    public static final String FC_CLIENT_VERSION = "6.1.19";
    public static final int DEFAULT_TIMED_EVENT_DURATION = 1;
    public static final int DEFAULT_DAY_EVENT_DURATION = 1;
    private static final String JSON_INITIAL_OPTIONS = "initialJsonOptions";
    private static final String INITIAL_OPTIONS = "initialOptions";
    private final Map<String, Entry> lastFetchedEntries = new HashMap<String, Entry>();
    private final Map<String, Object> options = new HashMap<String, Object>();
    private final Map<String, Object> initialOptions = new HashMap<String, Object>();
    private final Map<String, Object> serverSideOptions = new HashMap<String, Object>();
    private EntryProvider<? extends Entry> entryProvider;
    private final List<Registration> entryProviderDataListeners = new LinkedList<Registration>();
    private final Map<String, CustomCalendarView> customCalendarViews = new LinkedHashMap<String, CustomCalendarView>();
    private int timeslotsSelectedListenerCount;
    private Timezone browserTimezone;
    private String currentViewName;
    private LocalDate currentIntervalStart;
    private CalendarView currentView;
    private boolean refreshAllEntriesRequested;
    private Map<String, String> customNativeEventsMap = new LinkedHashMap<String, String>();
    private String eventDidMountCallback;

    public FullCalendar() {
        this.setMaxEntriesPerDayUnlimited();
        this.postConstruct();
    }

    public FullCalendar(int entryLimit) {
        if (entryLimit >= 0) {
            this.setMaxEntriesPerDay(entryLimit);
        } else {
            this.setMaxEntriesPerDayUnlimited();
        }
        this.setLocale(CalendarLocale.getDefaultLocale());
        this.postConstruct();
    }

    public FullCalendar(ObjectNode initialOptions) {
        if (initialOptions.hasNonNull("views")) {
            ObjectNode views = (ObjectNode)initialOptions.get("views");
            for (String viewName : views.propertyNames()) {
                ObjectNode viewSettings = (ObjectNode)views.get(viewName);
                CustomCalendarView.AnonymousCustomCalendarView anonymousView = new CustomCalendarView.AnonymousCustomCalendarView(viewName, viewSettings);
                this.customCalendarViews.put(anonymousView.getClientSideValue(), anonymousView);
            }
        }
        this.getElement().setPropertyJson(JSON_INITIAL_OPTIONS, (BaseJsonNode)Objects.requireNonNull(initialOptions));
        if (!initialOptions.hasNonNull(Option.LOCALE.getOptionKey())) {
            this.setLocale(CalendarLocale.getDefaultLocale());
        }
        this.postConstruct();
    }

    private void postConstruct() {
        this.setEntryProvider(EntryProvider.emptyInMemory());
        this.setPrefetchEnabled(true);
        this.currentView = CalendarViewImpl.DAY_GRID_MONTH;
        this.currentViewName = this.currentView.getName();
        this.addDatesRenderedListener((ComponentEventListener<DatesRenderedEvent>)(ComponentEventListener & Serializable)event -> {
            this.currentIntervalStart = event.getIntervalStart();
        });
        this.addViewSkeletonRenderedListener((ComponentEventListener<ViewSkeletonRenderedEvent>)(ComponentEventListener & Serializable)event -> {
            this.currentViewName = event.getViewName();
            this.currentView = event.getCalendarView().orElse(null);
        });
        this.setOption("handleWindowResize", (Object)false);
        this.setHeightFull();
        this.addClassName("vaadin-full-calendar");
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (!attachEvent.isInitialAttach()) {
            this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)executionContext -> {
                ObjectNode optionsJson = JsonFactory.createObject();
                if (!this.options.isEmpty()) {
                    this.options.forEach((key, value) -> optionsJson.set(key, JsonUtils.toJsonNode(value)));
                }
                this.getElement().callJsFunction("restoreStateFromServer", new Object[]{optionsJson, JsonUtils.toJsonNode(this.currentViewName), JsonUtils.toJsonNode(this.currentIntervalStart)});
            }));
        }
        this.updateEntryDidMountCallbackOnAttach();
    }

    public void allowDatesRenderEventOnOptionChange(boolean allow) {
        this.getElement().setProperty("noDatesRenderEventOnOptionSetting", !allow);
    }

    public void next() {
        this.getElement().callJsFunction("next", new Object[0]);
    }

    public void previous() {
        this.getElement().callJsFunction("previous", new Object[0]);
    }

    public void today() {
        this.getElement().callJsFunction("today", new Object[0]);
    }

    public void setEntryProvider(EntryProvider<? extends Entry> entryProvider) {
        Objects.requireNonNull(entryProvider);
        if (this.entryProvider != entryProvider) {
            if (this.entryProvider != null) {
                this.entryProvider.setCalendar(null);
            }
            this.entryProvider = entryProvider;
            entryProvider.setCalendar(this);
            this.entryProviderDataListeners.forEach(Registration::remove);
            this.entryProviderDataListeners.clear();
            this.entryProviderDataListeners.add(entryProvider.addEntryRefreshListener(event -> this.requestRefresh((Entry)event.getItemToRefresh())));
            this.entryProviderDataListeners.add(entryProvider.addEntriesChangeListener(event -> this.requestRefreshAllEntries()));
        }
    }

    public <R extends Entry, T extends EntryProvider<R>> T getEntryProvider() {
        return (T)this.entryProvider;
    }

    protected void requestRefresh(Entry item) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)pExecutionContext -> this.getEntryProvider().fetchById(item.getId()).ifPresent(refreshedEntry -> {
            this.lastFetchedEntries.put(refreshedEntry.getId(), (Entry)refreshedEntry);
            this.getElement().callJsFunction("refreshSingleEvent", new Object[]{refreshedEntry.getId()});
        })));
    }

    protected void requestRefreshAllEntries() {
        if (!this.refreshAllEntriesRequested) {
            this.refreshAllEntriesRequested = true;
            this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)pExecutionContext -> {
                this.getElement().callJsFunction("refreshAllEvents", new Object[0]);
                this.refreshAllEntriesRequested = false;
            }));
        }
    }

    public boolean isInMemoryEntryProvider() {
        return this.entryProvider instanceof InMemoryEntryProvider;
    }

    @ClientCallable
    protected ArrayNode fetchEntriesFromServer(ObjectNode query) {
        Objects.requireNonNull(query);
        Objects.requireNonNull(this.entryProvider);
        this.lastFetchedEntries.clear();
        LocalDateTime start = query.hasNonNull("start") ? JsonUtils.parseClientSideDateTime(query.get("start").asString()) : null;
        LocalDateTime end = query.hasNonNull("end") ? JsonUtils.parseClientSideDateTime(query.get("end").asString()) : null;
        ArrayNode array = JsonFactory.createArray();
        this.entryProvider.fetch(new EntryQuery(start, end, EntryQuery.AllDay.BOTH)).peek(entry -> {
            entry.setCalendar(this);
            entry.setKnownToTheClient(true);
            this.lastFetchedEntries.put(entry.getId(), (Entry)entry);
        }).map(Entry::toJson).forEach(arg_0 -> ((ArrayNode)array).add(arg_0));
        return array;
    }

    public Optional<Entry> getCachedEntryFromFetch(String id) {
        return Optional.ofNullable(this.lastFetchedEntries.get(id));
    }

    protected InMemoryEntryProvider<Entry> assureInMemoryProvider() {
        if (!(this.entryProvider instanceof InMemoryEntryProvider)) {
            throw new UnsupportedOperationException("Needs an InMemoryEntryProvider to work.");
        }
        return (InMemoryEntryProvider)this.entryProvider;
    }

    public void changeView(CalendarView view) {
        Objects.requireNonNull(view);
        this.lookupViewByClientSideValue(view.getClientSideValue()).orElseThrow(() -> new IllegalArgumentException("Unknown view: " + view.getClientSideValue() + ". If you want to use a custom view, please register it first by using addCustomView()."));
        this.currentView = view;
        this.currentViewName = view.getClientSideValue();
        this.getElement().callJsFunction("changeView", new Object[]{this.currentViewName});
    }

    public String getCurrentViewName() {
        return this.currentViewName;
    }

    public Optional<CalendarView> getCurrentView() {
        return Optional.ofNullable(this.currentView);
    }

    public void gotoDate(LocalDate date) {
        Objects.requireNonNull(date);
        this.getElement().callJsFunction("gotoDate", new Object[]{date.toString()});
    }

    public void scrollToTime(String duration) {
        Objects.requireNonNull(duration);
        this.getElement().callJsFunction("scrollToTime", new Object[]{duration});
    }

    public void scrollToTime(LocalTime duration) {
        Objects.requireNonNull(duration);
        this.getElement().callJsFunction("scrollToTime", new Object[]{duration.format(DateTimeFormatter.ISO_LOCAL_TIME)});
    }

    public void setOption(Option option, Object value) {
        this.setOption(option, value, null);
    }

    public void setOption(Option option, Object value, Object valueForServerSide) {
        this.setOption(option.getOptionKey(), value, valueForServerSide);
    }

    public void setOption(String option, Object value) {
        this.setOption(option, value, null);
    }

    public void setOption(String option, Object value, Object valueForServerSide) {
        this.callOptionUpdate(option, value, valueForServerSide, "setOption", new Serializable[0]);
    }

    private void callOptionUpdate(String option, Object value, Object valueForServerSide, String method, Serializable ... additionalParameters) {
        Objects.requireNonNull(option);
        boolean attached = this.isAttached();
        if (value == null) {
            this.initialOptions.remove(option);
            this.options.remove(option);
            this.serverSideOptions.remove(option);
        } else {
            if (attached) {
                this.options.put(option, value);
            } else {
                this.initialOptions.put(option, value);
            }
            if (valueForServerSide == null || valueForServerSide.equals(value)) {
                this.serverSideOptions.remove(option);
            } else {
                this.serverSideOptions.put(option, valueForServerSide);
            }
        }
        if (attached) {
            Object[] parameters = Stream.concat(Stream.of(option, value), Stream.of(additionalParameters)).toArray(Object[]::new);
            this.getElement().callJsFunction(method, parameters);
        } else {
            ObjectNode initialOptions = (ObjectNode)this.getElement().getPropertyRaw(INITIAL_OPTIONS);
            if (initialOptions == null) {
                initialOptions = JsonFactory.createObject();
                this.getElement().setPropertyJson(INITIAL_OPTIONS, (BaseJsonNode)initialOptions);
            }
            if (value == null) {
                initialOptions.remove(option);
            } else {
                initialOptions.set(option, JsonUtils.toJsonNode(value));
            }
        }
    }

    public void setFirstDay(DayOfWeek firstDay) {
        Objects.requireNonNull(firstDay);
        int value = firstDay == DayOfWeek.SUNDAY ? 0 : firstDay.getValue();
        this.setOption(Option.FIRST_DAY, (Object)value, (Object)firstDay);
    }

    @Deprecated(forRemoval=true)
    public void setHeight(int heightInPixels) {
        this.setHeight(heightInPixels, Unit.PIXELS);
    }

    @Deprecated(forRemoval=true)
    public void setHeightByParent() {
        this.setHeight("100%");
    }

    @Deprecated(forRemoval=true)
    public void setHeightAuto() {
        this.setHeight("auto");
    }

    public void setHeight(String height) {
        this.setOption(Option.HEIGHT, (Object)height);
    }

    public void setTimeslotsSelectable(boolean selectable) {
        this.setOption(Option.SELECTABLE, (Object)selectable);
    }

    public void setWeekNumbersVisible(boolean weekNumbersVisible) {
        this.setOption(Option.WEEK_NUMBERS, (Object)weekNumbersVisible);
    }

    @Deprecated(forRemoval=true)
    public void setWeekNumbersWithinDays(boolean weekNumbersWithinDays) {
    }

    public Locale getLocale() {
        Optional option = this.getOption(Option.LOCALE);
        if (!option.isPresent()) {
            return CalendarLocale.getDefaultLocale();
        }
        Object value = option.get();
        return value instanceof Locale ? (Locale)value : Locale.forLanguageTag((String)value);
    }

    public void setLocale(Locale locale) {
        Objects.requireNonNull(locale);
        this.setOption(Option.LOCALE, (Object)this.toClientSideLocale(locale), (Object)locale);
    }

    protected String toClientSideLocale(Locale locale) {
        return locale.toLanguageTag().toLowerCase();
    }

    public void setNowIndicatorShown(boolean shown) {
        this.setOption(Option.NOW_INDICATOR, (Object)shown);
    }

    public void setNumberClickable(boolean clickable) {
        this.setOption(Option.NAV_LINKS, (Object)clickable);
    }

    public void setEntryClassNamesCallback(String s) {
        this.getElement().callJsFunction("setEventClassNamesCallback", new Object[]{s});
    }

    public void setEntryDidMountCallback(String s) {
        this.eventDidMountCallback = s;
    }

    public void addEntryNativeEventListener(String eventName, String eventCallback) {
        this.customNativeEventsMap.put(eventName, eventCallback);
    }

    private void updateEntryDidMountCallbackOnAttach() {
        StringBuilder events = null;
        if (!this.customNativeEventsMap.isEmpty()) {
            events = new StringBuilder();
            for (Map.Entry<String, String> entry : this.customNativeEventsMap.entrySet()) {
                events.append("arguments[0].el.addEventListener('").append(entry.getKey()).append("', ").append(entry.getValue()).append(")\n");
            }
        }
        Object s = null;
        if (StringUtils.isNotBlank((CharSequence)this.eventDidMountCallback)) {
            if (events != null) {
                int index = this.eventDidMountCallback.lastIndexOf("}");
                s = this.eventDidMountCallback.substring(0, index);
                s = (String)s + String.valueOf(events);
                s = (String)s + this.eventDidMountCallback.substring(index);
            } else {
                s = this.eventDidMountCallback;
            }
        } else if (events != null) {
            s = "function(info) {\n" + String.valueOf(events) + "}";
        }
        if (s != null) {
            this.getElement().callJsFunction("setEventDidMountCallback", new Object[]{s});
        }
    }

    public void setEntryWillUnmountCallback(String s) {
        this.getElement().callJsFunction("setEventWillUnmountCallback", new Object[]{s});
    }

    public void setEntryContentCallback(String s) {
        this.setOption("eventContent", (Object)s);
    }

    public void setBusinessHours(BusinessHours ... hours) {
        Objects.requireNonNull(hours);
        this.setOption(Option.BUSINESS_HOURS, (Object)JsonUtils.toJsonNode(Arrays.stream(hours).map(BusinessHours::toJson)), (Object)hours);
    }

    public void removeBusinessHours() {
        this.setOption(Option.BUSINESS_HOURS, null);
    }

    public void setSnapDuration(String duration) {
        Objects.requireNonNull(duration);
        this.setOption(Option.SNAP_DURATION, (Object)duration);
    }

    public void setSlotMinTime(LocalTime slotMinTime) {
        Objects.requireNonNull(slotMinTime);
        this.setOption(Option.SLOT_MIN_TIME, (Object)JsonUtils.toJsonNode(slotMinTime != null ? slotMinTime : "00:00:00"));
    }

    public boolean getFixedWeekCount() {
        return this.getOption(Option.FIXED_WEEK_COUNT).orElse(true);
    }

    public void setFixedWeekCount(boolean fixedWeekCount) {
        this.setOption(Option.FIXED_WEEK_COUNT, (Object)fixedWeekCount);
    }

    public void setSlotMaxTime(LocalTime slotMaxTime) {
        Objects.requireNonNull(slotMaxTime);
        this.setOption(Option.SLOT_MAX_TIME, (Object)JsonUtils.toJsonNode(slotMaxTime != null ? slotMaxTime : "24:00:00"));
    }

    public Timezone getTimezone() {
        return this.getOption(Option.TIMEZONE).orElse(Timezone.UTC);
    }

    public void setTimezone(Timezone timezone) {
        Objects.requireNonNull(timezone);
        Timezone oldTimezone = this.getTimezone();
        if (!timezone.equals(oldTimezone)) {
            this.setOption(Option.TIMEZONE, (Object)timezone.getClientSideValue(), (Object)timezone);
        }
    }

    public boolean getEntryDurationEditable() {
        return this.getOption(Option.ENTRY_DURATION_EDITABLE).orElse(true);
    }

    public void setEntryDurationEditable(boolean editable) {
        this.setOption(Option.ENTRY_DURATION_EDITABLE, (Object)editable);
    }

    public boolean getEntryResizableFromStart() {
        return this.getOption(Option.ENTRY_RESIZABLE_FROM_START).orElse(false);
    }

    public void setEntryResizableFromStart(boolean editable) {
        this.setOption(Option.ENTRY_RESIZABLE_FROM_START, (Object)editable);
    }

    public boolean getEntryStartEditable() {
        return this.getOption(Option.ENTRY_START_EDITABLE).orElse(true);
    }

    public void setEntryStartEditable(boolean editable) {
        this.setOption(Option.ENTRY_START_EDITABLE, (Object)editable);
    }

    public boolean getEditable() {
        return this.getOption(Option.EDITABLE).orElse(false);
    }

    public void setEditable(boolean editable) {
        this.setOption(Option.EDITABLE, (Object)editable);
    }

    public void setMaxEntriesPerDay(int maxEntriesPerDay) {
        this.setOption(Option.MAX_ENTRIES_PER_DAY, (Object)maxEntriesPerDay);
    }

    public void setMaxEntriesPerDayFitToCell() {
        this.setOption(Option.MAX_ENTRIES_PER_DAY, (Object)true);
    }

    public void setMaxEntriesPerDayUnlimited() {
        this.setOption(Option.MAX_ENTRIES_PER_DAY, (Object)false);
    }

    public boolean getWeekends() {
        return this.getOption(Option.WEEKENDS).orElse(true);
    }

    public void setWeekends(boolean weekends) {
        this.setOption(Option.WEEKENDS, (Object)weekends);
    }

    public void setHeaderToolbar(Header header) {
        this.setOption(Option.HEADER_TOOLBAR, (Object)header.toJson());
    }

    public void setFooterToolbar(Footer footer) {
        this.setOption(Option.FOOTER_TOOLBAR, (Object)footer.toJson());
    }

    public boolean getColumnHeader() {
        return this.getOption(Option.COLUMN_HEADER).orElse(true);
    }

    public void setColumnHeader(boolean columnHeader) {
        this.setOption(Option.COLUMN_HEADER, (Object)columnHeader);
    }

    public Optional<Timezone> getBrowserTimezone() {
        return Optional.ofNullable(this.browserTimezone);
    }

    @ClientCallable
    protected void setBrowserTimezone(String timezoneId) {
        if (timezoneId != null) {
            this.browserTimezone = new Timezone(ZoneId.of(timezoneId));
            this.getEventBus().fireEvent((ComponentEvent)new BrowserTimezoneObtainedEvent(this, false, this.browserTimezone));
        }
    }

    public <T> Optional<T> getOption(Option option) {
        return this.getOption(option, false);
    }

    public <T> Optional<T> getOption(Option option, boolean forceClientSideValue) {
        return this.getOption(option.getOptionKey(), forceClientSideValue);
    }

    public <T> Optional<T> getOption(String option) {
        return this.getOption(option, false);
    }

    public <T> Optional<T> getOption(String option, boolean forceClientSideValue) {
        Objects.requireNonNull(option);
        if (!forceClientSideValue && this.serverSideOptions.containsKey(option)) {
            return Optional.ofNullable(this.serverSideOptions.get(option));
        }
        Object value = this.options.get(option);
        if (value == null) {
            value = this.initialOptions.get(option);
        }
        return Optional.ofNullable(value);
    }

    public void render() {
        this.getElement().callJsFunction("renderCalendar", new Object[0]);
    }

    public Registration addTimeslotClickedListener(ComponentEventListener<? extends TimeslotClickedEvent> listener) {
        Objects.requireNonNull(listener);
        return this.addListener(TimeslotClickedEvent.class, listener);
    }

    public Registration addEntryClickedListener(ComponentEventListener<EntryClickedEvent> listener) {
        Objects.requireNonNull(listener);
        return this.addListener(EntryClickedEvent.class, listener);
    }

    public Registration addEntryMouseEnterListener(ComponentEventListener<EntryMouseEnterEvent> listener) {
        Objects.requireNonNull(listener);
        return this.addListener(EntryMouseEnterEvent.class, listener);
    }

    public Registration addEntryMouseLeaveListener(ComponentEventListener<EntryMouseLeaveEvent> listener) {
        Objects.requireNonNull(listener);
        return this.addListener(EntryMouseLeaveEvent.class, listener);
    }

    public Registration addEntryResizedListener(ComponentEventListener<EntryResizedEvent> listener) {
        Objects.requireNonNull(listener);
        return this.addListener(EntryResizedEvent.class, listener);
    }

    public Registration addEntryDroppedListener(ComponentEventListener<EntryDroppedEvent> listener) {
        Objects.requireNonNull(listener);
        return this.addListener(EntryDroppedEvent.class, listener);
    }

    public Registration addDatesRenderedListener(ComponentEventListener<DatesRenderedEvent> listener) {
        Objects.requireNonNull(listener);
        return this.addListener(DatesRenderedEvent.class, listener);
    }

    public Registration addViewSkeletonRenderedListener(ComponentEventListener<ViewSkeletonRenderedEvent> listener) {
        Objects.requireNonNull(listener);
        return this.addListener(ViewSkeletonRenderedEvent.class, listener);
    }

    public Registration addViewChangedListener(ComponentEventListener<ViewSkeletonRenderedEvent> listener) {
        return this.addViewSkeletonRenderedListener(listener);
    }

    public Registration addTimeslotsSelectedListener(ComponentEventListener<? extends TimeslotsSelectedEvent> listener) {
        Objects.requireNonNull(listener);
        return this.addListener(TimeslotsSelectedEvent.class, listener);
    }

    public Registration addMoreLinkClickedListener(ComponentEventListener<MoreLinkClickedEvent> listener) {
        Objects.requireNonNull(listener);
        return this.addListener(MoreLinkClickedEvent.class, listener);
    }

    public Registration addDayNumberClickedListener(ComponentEventListener<DayNumberClickedEvent> listener) {
        Objects.requireNonNull(listener);
        return this.addListener(DayNumberClickedEvent.class, listener);
    }

    public Registration addWeekNumberClickedListener(ComponentEventListener<WeekNumberClickedEvent> listener) {
        Objects.requireNonNull(listener);
        return this.addListener(WeekNumberClickedEvent.class, listener);
    }

    public Registration addBrowserTimezoneObtainedListener(ComponentEventListener<BrowserTimezoneObtainedEvent> listener) {
        Objects.requireNonNull(listener);
        return this.addListener(BrowserTimezoneObtainedEvent.class, listener);
    }

    public void setMoreLinkClickAction(MoreLinkClickAction moreLinkClickAction) {
        this.getElement().setProperty("moreLinkClickAction", (moreLinkClickAction != null ? moreLinkClickAction : MoreLinkClickAction.POPUP).getClientSideValue());
    }

    public void setDragScrollActive(boolean dragScrollActive) {
        this.setOption(Option.DRAG_SCROLL, (Object)dragScrollActive);
    }

    public void setPrefetchEnabled(boolean prefetchEnabled) {
        this.getElement().setProperty("prefetchEnabled", prefetchEnabled);
    }

    public boolean isPrefetchEnabled() {
        return this.getElement().getProperty("prefetchEnabled", false);
    }

    @Deprecated(forRemoval=true)
    public <T extends CalendarView> Optional<T> lookupViewName(String clientSideValue) {
        return this.lookupViewByClientSideValue(clientSideValue);
    }

    public <T extends CalendarView> Optional<T> lookupViewByClientSideValue(String clientSideValue) {
        Optional<CalendarViewImpl> optional = CalendarViewImpl.ofClientSideValue(clientSideValue);
        if (optional.isPresent()) {
            return optional;
        }
        return Optional.ofNullable((CalendarView)this.customCalendarViews.get(clientSideValue));
    }

    public void setEntryDisplay(DisplayMode displayMode) {
        this.setOption(Option.ENTRY_DISPLAY, (Object)(displayMode != null ? displayMode : DisplayMode.AUTO));
    }

    public void setValidRangeStart(LocalDate start) {
        this.setValidRange(start, null);
    }

    public void setValidRangeEnd(LocalDate end) {
        this.setValidRange(null, end);
    }

    public void setValidRange(LocalDate start, LocalDate end) {
        if (start != null && end != null && !start.isBefore(end)) {
            throw new IllegalArgumentException("Start must be before end");
        }
        ObjectNode jsonObject = JsonFactory.createObject();
        if (start != null) {
            jsonObject.put("start", JsonUtils.formatClientSideDateString(start));
        }
        if (end != null) {
            jsonObject.put("end", JsonUtils.formatClientSideDateString(end));
        }
        this.setOption(Option.VALID_RANGE, (Object)jsonObject);
    }

    public void clearValidRange() {
        this.setValidRange(null, null);
    }

    public void clearSelection() {
        this.getElement().executeJs("this.calendar.unselect()", new Object[0]);
    }

    public Map<String, CustomCalendarView> getCustomCalendarViews() {
        return Collections.unmodifiableMap(this.customCalendarViews);
    }

    public void setCustomCalendarViews(CustomCalendarView ... customCalendarViews) {
        if (this.isAttached()) {
            throw new UnsupportedOperationException("Views can only be set before the component is attached");
        }
        if (this.getElement().hasProperty("customViews")) {
            throw new UnsupportedOperationException("Custom views can only be set once");
        }
        ObjectNode json = JsonFactory.createObject();
        for (CustomCalendarView customCalendarView : customCalendarViews) {
            this.customCalendarViews.put(customCalendarView.getClientSideValue(), customCalendarView);
            json.set(customCalendarView.getClientSideValue(), (JsonNode)customCalendarView.getViewSettings());
        }
        this.getElement().setPropertyJson("customViews", (BaseJsonNode)json);
    }

    public void addThemeVariants(FullCalendarVariant ... variants) {
        this.getThemeNames().addAll((Collection)Stream.of(variants).map(FullCalendarVariant::getVariantName).collect(Collectors.toList()));
    }

    public void removeThemeVariants(FullCalendarVariant ... variants) {
        this.getThemeNames().removeAll((Collection)Stream.of(variants).map(FullCalendarVariant::getVariantName).collect(Collectors.toList()));
    }

    public boolean hasThemeVariant(FullCalendarVariant variant) {
        return this.hasThemeName(variant.getVariantName());
    }

    public static enum Option {
        ALL_DAY_SLOT,
        ASPECT_RATIO,
        BUSINESS_HOURS,
        DAY_HEADERS,
        COLUMN_HEADER("dayHeaders"),
        CONTENT_HEIGHT,
        DAY_HEADER_FORMAT,
        DAY_MIN_WIDTH,
        DISPLAY_ENTRY_TIME,
        DIRECTION,
        DRAG_SCROLL,
        EDITABLE,
        ENTRY_BACKGROUND_COLOR,
        ENTRY_BORDER_COLOR,
        ENTRY_COLOR,
        ENTRY_DURATION_EDITABLE,
        ENTRY_MAX_STACK,
        ENTRY_MIN_HEIGHT,
        ENTRY_ORDER,
        ENTRY_ORDER_STRICT,
        ENTRY_DISPLAY,
        ENTRY_RESIZABLE_FROM_START,
        ENTRY_SHORT_HEIGHT,
        ENTRY_START_EDITABLE,
        ENTRY_TEXT_COLOR,
        ENTRY_TIME_FORMAT,
        EXPAND_ROWS,
        FIRST_DAY,
        FIXED_WEEK_COUNT,
        FOOTER_TOOLBAR,
        HEADER_TOOLBAR,
        HEIGHT,
        HIDDEN_DAYS,
        LIST_DAY_FORMAT,
        LIST_DAY_SIDE_FORMAT,
        LOCALE,
        MAX_ENTRIES_PER_DAY("dayMaxEvents"),
        MONTH_START_FORMAT,
        MULTI_MONTH_MAX_COLUMNS,
        MULTI_MONTH_MIN_WIDTH,
        MULTI_MONTH_TITLE_FORMAT,
        NAV_LINKS,
        NEXT_DAY_THRESHOLD,
        NOW_INDICATOR,
        SCROLL_TIME,
        SCROLL_TIME_RESET,
        SELECTABLE,
        SELECT_CONSTRAINT,
        SELECT_MIN_DISTANCE,
        SELECT_MIRROR,
        SELECT_OVERLAP,
        SHOW_NON_CURRENT_DATES,
        SLOT_DURATION,
        SLOT_ENTRY_OVERLAP,
        SLOT_LABEL_FORMAT,
        SLOT_LABEL_INTERVAL,
        SLOT_MAX_TIME,
        SLOT_MIN_TIME,
        SNAP_DURATION,
        STICKY_FOOTER_SCROLLBAR,
        STICKY_HEADER_DATES,
        TIMEZONE("timeZone"),
        UNSELECT_AUTO,
        UNSELECT_CANCEL,
        VALID_RANGE,
        WEEKENDS,
        WEEK_NUMBERS,
        WEEK_NUMBER_CALCULATION,
        WEEK_NUMBER_FORMAT,
        WEEK_TEXT,
        WEEK_TEXT_LONG;

        private final String optionKey;

        private Option() {
            this.optionKey = CaseUtils.toCamelCase((String)this.name().replace("ENTRY", "EVENT"), (boolean)false, (char[])new char[]{'_'});
        }

        private Option(String optionKey) {
            this.optionKey = optionKey;
        }

        String getOptionKey() {
            return this.optionKey;
        }
    }

    public static enum MoreLinkClickAction implements ClientSideValue
    {
        POPUP("popover"),
        DAY("day"),
        WEEK("week"),
        NOTHING("function");

        private final String clientSideValue;

        private MoreLinkClickAction(String clientSideValue) {
            this.clientSideValue = clientSideValue;
        }

        @Override
        public String getClientSideValue() {
            return this.clientSideValue;
        }
    }
}

