/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar;

import com.vaadin.flow.data.binder.Setter;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.vaadin.stefan.fullcalendar.BeanProperties;
import org.vaadin.stefan.fullcalendar.Delta;
import org.vaadin.stefan.fullcalendar.DisplayMode;
import org.vaadin.stefan.fullcalendar.FullCalendar;
import org.vaadin.stefan.fullcalendar.JsonFactory;
import org.vaadin.stefan.fullcalendar.JsonUtils;
import org.vaadin.stefan.fullcalendar.RecurringTime;
import org.vaadin.stefan.fullcalendar.Timezone;
import org.vaadin.stefan.fullcalendar.converters.DayOfWeekItemConverter;
import org.vaadin.stefan.fullcalendar.converters.JsonItemPropertyConverter;
import org.vaadin.stefan.fullcalendar.converters.LocalDateConverter;
import org.vaadin.stefan.fullcalendar.converters.LocalDateTimeConverter;
import org.vaadin.stefan.fullcalendar.converters.RecurringTimeConverter;
import org.vaadin.stefan.fullcalendar.json.JsonConverter;
import org.vaadin.stefan.fullcalendar.json.JsonIgnore;
import org.vaadin.stefan.fullcalendar.json.JsonName;
import org.vaadin.stefan.fullcalendar.json.JsonUpdateAllowed;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.NullNode;
import tools.jackson.databind.node.ObjectNode;

public class Entry {
    private static final Set<BeanProperties<Entry>> PROPERTIES = BeanProperties.read(Entry.class);
    private final String id;
    private String groupId;
    private String title;
    @JsonUpdateAllowed
    @JsonConverter(value=LocalDateTimeConverter.class)
    private LocalDateTime start;
    @JsonUpdateAllowed
    @JsonConverter(value=LocalDateTimeConverter.class)
    private LocalDateTime end;
    @JsonUpdateAllowed
    private boolean allDay;
    private boolean editable = true;
    private Boolean startEditable;
    private Boolean durationEditable;
    private String color;
    private String constraint;
    private String backgroundColor;
    private String borderColor;
    private String textColor;
    private boolean overlap = true;
    @JsonName(value="display")
    @NonNull
    private DisplayMode displayMode = DisplayMode.AUTO;
    @JsonName(value="startRecur")
    @JsonConverter(value=LocalDateConverter.class)
    private LocalDate recurringStartDate;
    @JsonName(value="endRecur")
    @JsonConverter(value=LocalDateConverter.class)
    private LocalDate recurringEndDate;
    @JsonName(value="startTime")
    @JsonConverter(value=RecurringTimeConverter.class)
    private RecurringTime recurringStartTime;
    @JsonName(value="endTime")
    @JsonConverter(value=RecurringTimeConverter.class)
    private RecurringTime recurringEndTime;
    @JsonName(value="daysOfWeek")
    @JsonConverter(value=DayOfWeekItemConverter.class)
    private Set<DayOfWeek> recurringDaysOfWeek;
    private Set<String> classNames;
    private Map<String, Object> customProperties;
    @JsonIgnore
    private boolean knownToTheClient;
    @JsonIgnore
    private FullCalendar calendar;

    public Entry() {
        this(null);
    }

    public Entry(String id) {
        this.id = id == null ? UUID.randomUUID().toString() : id;
    }

    public Optional<FullCalendar> getCalendar() {
        return Optional.ofNullable(this.calendar);
    }

    public void setCalendar(FullCalendar calendar) {
        if (this.calendar != null && calendar != null && this.calendar != calendar) {
            throw new UnsupportedOperationException("This entry is already attached to a calendar instance. Please remove it first from the old one.");
        }
        this.calendar = calendar;
    }

    public ObjectNode toJson() {
        ObjectNode json = JsonFactory.createObject();
        this.streamProperties().forEach(def -> {
            String name = def.getName();
            Field field = def.getField();
            try {
                if (field.getAnnotation(JsonIgnore.class) == null) {
                    JsonNode jsonValue;
                    Object value = def.getGetter().apply((Object)this);
                    JsonConverter converterAnnotation = field.getAnnotation(JsonConverter.class);
                    JsonItemPropertyConverter converter = null;
                    if (converterAnnotation != null) {
                        converter = converterAnnotation.value().getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    if ((jsonValue = converter != null && converter.supports(value) ? converter.toClientModel(value, this) : JsonUtils.toJsonNode(value)) != null && !(jsonValue instanceof NullNode)) {
                        String jsonName = name;
                        JsonName nameAnnotation = field.getAnnotation(JsonName.class);
                        if (nameAnnotation != null) {
                            jsonName = nameAnnotation.value();
                        }
                        json.set(jsonName, jsonValue);
                    }
                }
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        });
        return json;
    }

    public void updateFromJson(ObjectNode jsonObject) {
        this.updateFromJson(jsonObject, true);
    }

    public void updateFromJson(ObjectNode jsonObject, boolean requiresMatchingId) {
        if (requiresMatchingId) {
            if (!jsonObject.hasNonNull("id")) {
                throw new IllegalArgumentException("JsonObject has no id. Id matching is required.");
            }
            String idString = jsonObject.get("id").asString();
            if (!this.id.equals(idString)) {
                throw new IllegalArgumentException("Id matching is required. This id is " + this.id + " but the json object provided " + idString);
            }
        }
        this.streamProperties().forEach(def -> {
            String name = def.getName();
            Field field = def.getField();
            try {
                if (field.getAnnotation(JsonIgnore.class) == null && field.getAnnotation(JsonUpdateAllowed.class) != null) {
                    Setter setter = def.getSetter().orElseThrow(() -> new UnsupportedOperationException("No setter found for field " + name));
                    String jsonName = name;
                    JsonName nameAnnotation = field.getAnnotation(JsonName.class);
                    if (nameAnnotation != null) {
                        jsonName = nameAnnotation.value();
                    }
                    if (jsonObject.hasNonNull(jsonName)) {
                        JsonConverter converterAnnotation = field.getAnnotation(JsonConverter.class);
                        JsonItemPropertyConverter converter = null;
                        if (converterAnnotation != null) {
                            converter = converterAnnotation.value().getConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        JsonNode jsonValue = jsonObject.get(jsonName);
                        Object newValue = converter != null ? converter.toServerModel(jsonValue, this) : JsonUtils.ofJsonNode(jsonValue);
                        setter.accept((Object)this, newValue);
                    }
                }
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        });
    }

    protected boolean isValidJsonSource(ObjectNode jsonObject) {
        return jsonObject.hasNonNull("id") && Objects.equals(jsonObject.get("id").asString(), this.getId());
    }

    public <T extends Entry> T copy() {
        try {
            Entry copy = (Entry)this.getClass().getConstructor(String.class).newInstance(this.getId());
            Entry.copy(this, copy, false);
            return (T)copy;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public <T extends Entry> T copyAsType(Class<T> targetType) {
        try {
            Entry copy = (Entry)targetType.getConstructor(String.class).newInstance(this.getId());
            Entry.copy(this, copy, true);
            return (T)copy;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public void copyFrom(Entry source) {
        this.copyFrom(source, false);
    }

    public void copyFrom(Entry source, boolean ignoreId) {
        if (!ignoreId && !source.getId().equals(this.getId())) {
            throw new IllegalArgumentException("IDs must match");
        }
        Entry.copy(source, this, false);
    }

    public static void copy(Entry source, Entry target, boolean ignoreTypeDifference) {
        if (!ignoreTypeDifference && !source.getClass().equals(target.getClass())) {
            throw new IllegalArgumentException("Both parameters must be of the SAME class.");
        }
        source.streamProperties().forEach(def -> {
            ValueProvider getter = def.getGetter();
            def.getSetter().ifPresent(setter -> {
                try {
                    Object value = getter.apply((Object)source);
                    if (value instanceof Collection) {
                        Collection collection = Entry.newInstance((Collection)value);
                        collection.addAll((Collection)value);
                        value = collection;
                    } else if (value instanceof Map) {
                        Map map = Entry.newInstance((Map)value);
                        map.putAll((Map)value);
                        value = map;
                    } else if (value instanceof Object[]) {
                        value = ((Object[])value).clone();
                    }
                    setter.accept((Object)target, value);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException("Property " + def.getName() + " threw an exception", throwable);
                }
            });
        });
    }

    private static <T> T newInstance(T value) throws Exception {
        try {
            return (T)value.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            if (value instanceof Set) {
                return (T)new LinkedHashSet();
            }
            if (value instanceof Collection) {
                return (T)new ArrayList();
            }
            if (value instanceof Map) {
                return (T)new HashMap();
            }
            throw new IllegalArgumentException("Type " + String.valueOf(value.getClass()) + " has no public no-args constructor and no fallback.");
        }
    }

    protected Stream<BeanProperties<Entry>> streamProperties() {
        return PROPERTIES.stream();
    }

    protected Stream<BeanProperties<Entry>> streamUpdateableProperties() {
        return this.streamProperties().filter(def -> {
            Field field = def.getField();
            try {
                return field.getAnnotation(JsonIgnore.class) == null && field.getAnnotation(JsonUpdateAllowed.class) != null && def.getSetter().isPresent();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        });
    }

    public ObjectNode toJsonWithIdOnly() {
        ObjectNode jsonObject = JsonFactory.createObject();
        jsonObject.put("id", this.getId());
        return jsonObject;
    }

    public Instant getStartAsInstant() {
        return (Instant)this.convertNullable(this.getStart(), (SerializableFunction & Serializable)start -> start.toInstant(ZoneOffset.UTC));
    }

    public LocalDate getStartAsLocalDate() {
        return (LocalDate)this.convertNullable(this.getStart(), LocalDateTime::toLocalDate);
    }

    public ZonedDateTime getStartWithTimezone() {
        return this.getStartTimezone().applyTimezone(this.getStart());
    }

    public LocalDateTime getStartWithOffset() {
        return this.getStartWithOffset(this.getStartTimezone());
    }

    public LocalDateTime getStartWithOffset(Timezone timezone) {
        return timezone.applyTimezoneOffset(this.getStart());
    }

    public void setStart(LocalDateTime start) {
        this.start = start;
    }

    public void setStart(Instant start) {
        this.setStart(start != null ? LocalDateTime.ofInstant(start, Timezone.ZONE_ID_UTC) : null);
    }

    public void setStart(LocalDate start) {
        this.setStart(start != null ? start.atStartOfDay() : null);
    }

    public void setStartWithTimezone(ZonedDateTime startWithTimezone) {
        this.setStart(startWithTimezone != null ? startWithTimezone.withZoneSameInstant(Timezone.ZONE_ID_UTC).toLocalDateTime() : null);
    }

    public void setStartWithOffset(LocalDateTime startWithTimezone) {
        this.setStartWithOffset(startWithTimezone, this.getStartTimezone());
    }

    public void setStartWithOffset(LocalDateTime startWithTimezone, Timezone timezone) {
        this.setStart(timezone.removeTimezoneOffset(startWithTimezone));
    }

    public void clearStart() {
        this.setStart((LocalDateTime)null);
    }

    public Instant getEndAsInstant() {
        return (Instant)this.convertNullable(this.getEnd(), (SerializableFunction & Serializable)end -> end.toInstant(ZoneOffset.UTC));
    }

    public LocalDate getEndAsLocalDate() {
        return (LocalDate)this.convertNullable(this.getEnd(), LocalDateTime::toLocalDate);
    }

    public ZonedDateTime getEndWithTimezone() {
        return this.getEndTimezone().applyTimezone(this.getEnd());
    }

    public LocalDateTime getEndWithOffset() {
        return this.getEndTimezone().applyTimezoneOffset(this.getEnd());
    }

    public LocalDateTime getEndWithOffset(Timezone timezone) {
        return timezone.applyTimezoneOffset(this.getEnd());
    }

    public void setEnd(LocalDateTime end) {
        this.end = end;
    }

    public void setEnd(Instant end) {
        this.setEnd(end != null ? LocalDateTime.ofInstant(end, Timezone.ZONE_ID_UTC) : null);
    }

    public void setEnd(LocalDate end) {
        this.setEnd(end != null ? end.atStartOfDay() : null);
    }

    public void setEndWithTimezone(ZonedDateTime endWithTimezone) {
        this.setEnd(endWithTimezone != null ? endWithTimezone.withZoneSameInstant(Timezone.ZONE_ID_UTC).toLocalDateTime() : null);
    }

    public void setEndWithOffset(LocalDateTime endWithTimezone) {
        this.setEnd(this.getEndTimezone().removeTimezoneOffset(endWithTimezone));
    }

    public void setEndWithOffset(LocalDateTime endWithTimezone, Timezone timezone) {
        this.setEnd(timezone.removeTimezoneOffset(endWithTimezone));
    }

    public void clearEnd() {
        this.setEnd((LocalDateTime)null);
    }

    public void moveStartEnd(Delta delta) {
        this.moveStart(delta);
        this.moveEnd(delta);
    }

    public void moveStart(Delta delta) {
        this.setStart(delta.applyOn(this.getStart()));
    }

    public void moveEnd(Delta delta) {
        this.setEnd(delta.applyOn(this.getEnd()));
    }

    public Timezone getStartTimezone() {
        return this.calendar != null ? this.calendar.getTimezone() : Timezone.UTC;
    }

    public Timezone getEndTimezone() {
        return this.calendar != null ? this.calendar.getTimezone() : Timezone.UTC;
    }

    public Set<String> getOrCreateClassNames() {
        Set<String> classNames = this.getClassNames();
        if (classNames == null) {
            classNames = new LinkedHashSet<String>();
            this.setClassNames(classNames);
        }
        return classNames;
    }

    @Deprecated(forRemoval=true)
    public void assignClassName(String className) {
        this.assignClassNames(Objects.requireNonNull(className));
    }

    @Deprecated(forRemoval=true)
    public void assignClassNames(String ... classNames) {
        this.assignClassNames(Arrays.asList(classNames));
    }

    @Deprecated(forRemoval=true)
    public void assignClassNames(Collection<String> classNames) {
        Objects.requireNonNull(classNames);
        this.getOrCreateClassNames().addAll(classNames);
    }

    public void addClassNames(String ... classNames) {
        this.assignClassNames(Arrays.asList(classNames));
    }

    public void addClassNames(Collection<String> classNames) {
        Objects.requireNonNull(classNames);
        this.getOrCreateClassNames().addAll(classNames);
    }

    @Deprecated(forRemoval=true)
    public void unassignClassName(String className) {
        this.unassignClassNames(Objects.requireNonNull(className));
    }

    @Deprecated(forRemoval=true)
    public void unassignClassNames(String ... classNames) {
        this.unassignClassNames(Arrays.asList(classNames));
    }

    @Deprecated(forRemoval=true)
    public void unassignClassNames(Collection<String> classNamesToRemove) {
        this.removeClassNames(classNamesToRemove);
    }

    @Deprecated(forRemoval=true)
    public void unassignAllClassNames() {
        this.removeClassNames();
    }

    public void removeClassNames(String ... classNames) {
        this.removeClassNames(Arrays.asList(classNames));
    }

    public void removeClassNames(Collection<String> classNamesToRemove) {
        Set<String> classNames = this.getClassNames();
        if (classNames != null) {
            classNames.removeAll(classNamesToRemove);
        }
    }

    public void removeClassNames() {
        this.setClassNames(null);
    }

    public int getClassNamesSize() {
        Set<String> classNames = this.getClassNames();
        return classNames != null ? classNames.size() : 0;
    }

    public boolean hasClassNames() {
        Set<String> classNames = this.getClassNames();
        return classNames != null && !classNames.isEmpty();
    }

    public boolean isOverlapAllowed() {
        return this.isOverlap();
    }

    public void setOverlapAllowed(boolean overlap) {
        this.setOverlap(overlap);
    }

    public boolean isDurationEditable() {
        return this.isEditable() || this.durationEditable == Boolean.TRUE;
    }

    public boolean isStartEditable() {
        return this.isEditable() || this.startEditable == Boolean.TRUE;
    }

    public void setConstraint(String constraint) {
        this.constraint = StringUtils.trimToNull((String)constraint);
    }

    public void setColor(String color) {
        this.color = StringUtils.trimToNull((String)color);
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = StringUtils.trimToNull((String)backgroundColor);
    }

    public void setTextColor(String textColor) {
        this.textColor = StringUtils.trimToNull((String)textColor);
    }

    public void setBorderColor(String borderColor) {
        this.borderColor = StringUtils.trimToNull((String)borderColor);
    }

    public String getDescription() {
        return (String)this.getCustomProperty("description");
    }

    public void setDescription(String description) {
        this.setCustomProperty("description", description);
    }

    public void setDisplayMode(DisplayMode displayMode) {
        this.displayMode = displayMode != null ? displayMode : DisplayMode.AUTO;
    }

    public boolean isRecurring() {
        Set<DayOfWeek> daysOfWeek = this.getRecurringDaysOfWeek();
        return daysOfWeek != null && !daysOfWeek.isEmpty() || this.getRecurringEndDate() != null || this.getRecurringStartDate() != null || this.getRecurringStartTimeAsLocalTime() != null || this.getRecurringEndTimeAsLocalTime() != null;
    }

    public void setRecurringDaysOfWeek(DayOfWeek ... daysOfWeek) {
        this.setRecurringDaysOfWeek((Set<DayOfWeek>)(daysOfWeek.length == 0 ? null : new HashSet<DayOfWeek>(Arrays.asList(daysOfWeek))));
    }

    public void setRecurringDaysOfWeek(Set<DayOfWeek> daysOfWeek) {
        this.recurringDaysOfWeek = daysOfWeek;
    }

    public Set<DayOfWeek> getRecurringDaysOfWeek() {
        return this.recurringDaysOfWeek;
    }

    public RecurringTime getRecurringStartTime() {
        return this.recurringStartTime;
    }

    public LocalTime getRecurringStartTimeAsLocalTime() {
        return this.recurringStartTime != null ? this.recurringStartTime.toLocalTime() : null;
    }

    public void setRecurringStartTime(RecurringTime start) {
        this.recurringStartTime = start;
    }

    public void setRecurringStartTime(LocalTime start) {
        this.setRecurringStartTime(start != null ? RecurringTime.of(start) : null);
    }

    public RecurringTime getRecurringEndTime() {
        return this.recurringEndTime;
    }

    public LocalTime getRecurringEndTimeAsLocalTime() {
        return this.recurringEndTime != null ? this.recurringEndTime.toLocalTime() : null;
    }

    public void setRecurringEndTime(RecurringTime end) {
        this.recurringEndTime = end;
    }

    public void setRecurringEndTime(LocalTime end) {
        this.setRecurringEndTime(end != null ? RecurringTime.of(end) : null);
    }

    public LocalDateTime getRecurringStart() {
        LocalDate startDate = this.getRecurringStartDate();
        if (startDate == null) {
            return null;
        }
        RecurringTime startTime = this.getRecurringStartTime();
        if (startTime == null) {
            return startDate.atStartOfDay();
        }
        return startDate.atStartOfDay().plusHours(startTime.getHour()).plusMinutes(startTime.getMinute());
    }

    public LocalDateTime getRecurringEnd() {
        LocalDate endDate = this.getRecurringEndDate();
        if (endDate == null) {
            return null;
        }
        RecurringTime endTime = this.getRecurringEndTime();
        if (endTime == null) {
            return endDate.plusDays(1L).atStartOfDay().minusSeconds(1L);
        }
        return endDate.atStartOfDay().plusHours(endTime.getHour()).plusMinutes(endTime.getMinute());
    }

    public void setRecurringStart(LocalDateTime recurringStart) {
        this.setRecurringStartDate(recurringStart != null ? recurringStart.toLocalDate() : null);
        this.setRecurringStartTime(recurringStart != null ? recurringStart.toLocalTime() : null);
    }

    public void setRecurringEnd(LocalDateTime recurringEnd) {
        this.setRecurringEndDate(recurringEnd != null ? recurringEnd.toLocalDate() : null);
        this.setRecurringEndTime(recurringEnd != null ? recurringEnd.toLocalTime() : null);
    }

    public void clearRecurringStart() {
        this.setRecurringStartDate(null);
        this.setRecurringStartTime((RecurringTime)null);
    }

    public void clearRecurringEnd() {
        this.setRecurringEndDate(null);
        this.setRecurringEndTime((RecurringTime)null);
    }

    public void setCustomProperties(Map<String, Object> customProperties) {
        this.customProperties = customProperties;
    }

    public void setCustomProperty(String key, Object value) {
        Objects.requireNonNull(key);
        this.getOrCreateCustomProperties().put(key, value);
    }

    public <T> T getCustomProperty(String key) {
        return (T)this.getCustomPropertiesOrEmpty().get(key);
    }

    public void removeCustomProperty(String key) {
        Map<String, Object> customProperties = this.getCustomProperties();
        if (customProperties != null) {
            customProperties.remove(Objects.requireNonNull(key));
        }
    }

    public void removeCustomProperty(String key, Object value) {
        Map<String, Object> customProperties = this.getCustomProperties();
        if (customProperties != null) {
            customProperties.remove(Objects.requireNonNull(key), Objects.requireNonNull(value));
        }
    }

    public Map<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public Map<String, Object> getCustomPropertiesOrEmpty() {
        return this.customProperties != null ? Collections.unmodifiableMap(this.customProperties) : Collections.emptyMap();
    }

    public Map<String, Object> getOrCreateCustomProperties() {
        if (this.customProperties == null) {
            this.customProperties = new HashMap<String, Object>();
        }
        return this.customProperties;
    }

    protected <T, R> R convertNullable(T value, SerializableFunction<T, R> converter) {
        return (R)(value != null ? converter.apply(value) : null);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public LocalDateTime getStart() {
        return this.start;
    }

    @Generated
    public LocalDateTime getEnd() {
        return this.end;
    }

    @Generated
    public boolean isAllDay() {
        return this.allDay;
    }

    @Generated
    public boolean isEditable() {
        return this.editable;
    }

    @Generated
    public Boolean getStartEditable() {
        return this.startEditable;
    }

    @Generated
    public Boolean getDurationEditable() {
        return this.durationEditable;
    }

    @Generated
    public String getColor() {
        return this.color;
    }

    @Generated
    public String getConstraint() {
        return this.constraint;
    }

    @Generated
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    @Generated
    public String getBorderColor() {
        return this.borderColor;
    }

    @Generated
    public String getTextColor() {
        return this.textColor;
    }

    @Generated
    public boolean isOverlap() {
        return this.overlap;
    }

    @NonNull
    @Generated
    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    @Generated
    public LocalDate getRecurringStartDate() {
        return this.recurringStartDate;
    }

    @Generated
    public LocalDate getRecurringEndDate() {
        return this.recurringEndDate;
    }

    @Generated
    public Set<String> getClassNames() {
        return this.classNames;
    }

    @Generated
    public boolean isKnownToTheClient() {
        return this.knownToTheClient;
    }

    @Generated
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setAllDay(boolean allDay) {
        this.allDay = allDay;
    }

    @Generated
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Generated
    public void setStartEditable(Boolean startEditable) {
        this.startEditable = startEditable;
    }

    @Generated
    public void setDurationEditable(Boolean durationEditable) {
        this.durationEditable = durationEditable;
    }

    @Generated
    public void setOverlap(boolean overlap) {
        this.overlap = overlap;
    }

    @Generated
    public void setRecurringStartDate(LocalDate recurringStartDate) {
        this.recurringStartDate = recurringStartDate;
    }

    @Generated
    public void setRecurringEndDate(LocalDate recurringEndDate) {
        this.recurringEndDate = recurringEndDate;
    }

    @Generated
    public void setClassNames(Set<String> classNames) {
        this.classNames = classNames;
    }

    @Generated
    public void setKnownToTheClient(boolean knownToTheClient) {
        this.knownToTheClient = knownToTheClient;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Entry)) {
            return false;
        }
        Entry other = (Entry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Entry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public static final class Fields {
        public static final String ID = "id";
        public static final String GROUP_ID = "groupId";
        public static final String TITLE = "title";
        public static final String START = "start";
        public static final String END = "end";
        public static final String ALL_DAY = "allDay";
        public static final String EDITABLE = "editable";
        public static final String START_EDITABLE = "startEditable";
        public static final String DURATION_EDITABLE = "durationEditable";
        public static final String COLOR = "color";
        public static final String CONSTRAINT = "constraint";
        public static final String BACKGROUND_COLOR = "backgroundColor";
        public static final String BORDER_COLOR = "borderColor";
        public static final String TEXT_COLOR = "textColor";
        public static final String OVERLAP = "overlap";
        public static final String DISPLAY_MODE = "displayMode";
        public static final String RECURRING_START_DATE = "recurringStartDate";
        public static final String RECURRING_END_DATE = "recurringEndDate";
        public static final String RECURRING_START_TIME = "recurringStartTime";
        public static final String RECURRING_END_TIME = "recurringEndTime";
        public static final String RECURRING_DAYS_OF_WEEK = "recurringDaysOfWeek";
        public static final String CLASS_NAMES = "classNames";
        public static final String CUSTOM_PROPERTIES = "customProperties";
        public static final String KNOWN_TO_THE_CLIENT = "knownToTheClient";
        public static final String CALENDAR = "calendar";
    }

    public static final class EntryCustomProperties {
        public static final String DESCRIPTION = "description";
    }
}

