/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar;

import java.time.DayOfWeek;
import java.time.LocalTime;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.vaadin.stefan.fullcalendar.JsonFactory;
import org.vaadin.stefan.fullcalendar.JsonUtils;
import tools.jackson.databind.node.ObjectNode;

public class BusinessHours {
    public static final Set<DayOfWeek> ALL_DAYS = Set.of(DayOfWeek.values());
    public static final Set<DayOfWeek> DEFAULT_BUSINESS_WEEK = Set.of(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
    private final Set<DayOfWeek> dayOfWeeks;
    private final LocalTime start;
    private final LocalTime end;

    public static BusinessHours of(DayOfWeek[] dayOfWeeks) {
        return BusinessHours.of(Set.of(dayOfWeeks));
    }

    public static BusinessHours of(DayOfWeek dayOfWeek, DayOfWeek ... additionalDaysOfWeek) {
        return BusinessHours.of(Stream.concat(Stream.of(dayOfWeek), Stream.of(additionalDaysOfWeek)).collect(Collectors.toSet()));
    }

    public static BusinessHours of(Set<DayOfWeek> dayOfWeeks) {
        return new BusinessHours(LocalTime.MIN, LocalTime.MAX, dayOfWeeks);
    }

    public static BusinessHours allDays() {
        return BusinessHours.of(ALL_DAYS);
    }

    public static BusinessHours businessWeek() {
        return BusinessHours.of(DEFAULT_BUSINESS_WEEK);
    }

    private BusinessHours(LocalTime start, LocalTime end, Set<DayOfWeek> dayOfWeeks) {
        if (dayOfWeeks == null || dayOfWeeks.isEmpty()) {
            throw new IllegalArgumentException("Days of week must not be null nor empty");
        }
        if (start == null || end == null) {
            throw new IllegalArgumentException("Times must not be null");
        }
        if (end.isBefore(start)) {
            throw new IllegalArgumentException("End must not be before start");
        }
        this.dayOfWeeks = dayOfWeeks;
        this.start = start;
        this.end = end;
    }

    public BusinessHours start(LocalTime start) {
        return new BusinessHours(start, this.end, this.dayOfWeeks);
    }

    public BusinessHours end(LocalTime end) {
        return new BusinessHours(this.start, end, this.dayOfWeeks);
    }

    public BusinessHours start(int startingHour) {
        return this.start(startingHour == 24 ? LocalTime.MAX : LocalTime.of(startingHour, 0));
    }

    public BusinessHours end(int endingHour) {
        return this.end(endingHour == 24 ? LocalTime.MAX : LocalTime.of(endingHour, 0));
    }

    public LocalTime getEnd() {
        return this.end;
    }

    public LocalTime getStart() {
        return this.start;
    }

    public Set<DayOfWeek> getDayOfWeeks() {
        return Collections.unmodifiableSet(this.dayOfWeeks);
    }

    protected ObjectNode toJson() {
        ObjectNode jsonObject = JsonFactory.createObject();
        jsonObject.set("daysOfWeek", JsonUtils.toJsonNode(this.dayOfWeeks.stream().map(BusinessHours::convertToClientSideDow)));
        jsonObject.set("startTime", JsonUtils.toJsonNode(this.start));
        jsonObject.set("endTime", JsonUtils.toJsonNode(this.end == LocalTime.MAX ? "24:00" : this.end));
        return jsonObject;
    }

    public static int convertToClientSideDow(DayOfWeek dayOfWeek) {
        return Objects.requireNonNull(dayOfWeek) == DayOfWeek.SUNDAY ? 0 : dayOfWeek.getValue();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessHours)) {
            return false;
        }
        BusinessHours other = (BusinessHours)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<DayOfWeek> this$dayOfWeeks = this.getDayOfWeeks();
        Set<DayOfWeek> other$dayOfWeeks = other.getDayOfWeeks();
        if (this$dayOfWeeks == null ? other$dayOfWeeks != null : !((Object)this$dayOfWeeks).equals(other$dayOfWeeks)) {
            return false;
        }
        LocalTime this$start = this.getStart();
        LocalTime other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        LocalTime this$end = this.getEnd();
        LocalTime other$end = other.getEnd();
        return !(this$end == null ? other$end != null : !((Object)this$end).equals(other$end));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BusinessHours;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<DayOfWeek> $dayOfWeeks = this.getDayOfWeeks();
        result = result * 59 + ($dayOfWeeks == null ? 43 : ((Object)$dayOfWeeks).hashCode());
        LocalTime $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        LocalTime $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BusinessHours(dayOfWeeks=" + String.valueOf(this.getDayOfWeeks()) + ", start=" + String.valueOf(this.getStart()) + ", end=" + String.valueOf(this.getEnd()) + ")";
    }
}

