/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.vaadin.stefan.fullcalendar.BeanProperties;
import org.vaadin.stefan.fullcalendar.Entry;
import org.vaadin.stefan.fullcalendar.FullCalendar;
import org.vaadin.stefan.fullcalendar.Resource;
import org.vaadin.stefan.fullcalendar.Scheduler;
import org.vaadin.stefan.fullcalendar.converter.ResourceConverter;
import org.vaadin.stefan.fullcalendar.json.JsonConverter;
import org.vaadin.stefan.fullcalendar.json.JsonName;
import org.vaadin.stefan.fullcalendar.json.JsonUpdateAllowed;
import tools.jackson.databind.node.ObjectNode;

public class ResourceEntry
extends Entry {
    private static final Set PROPERTIES = BeanProperties.read(ResourceEntry.class);
    private boolean resourceEditable = true;
    @JsonUpdateAllowed
    @JsonName(value="resourceIds")
    @JsonConverter(value=ResourceConverter.class)
    private Set<Resource> resources;

    public ResourceEntry(String id) {
        super(id);
    }

    protected Stream<BeanProperties<Entry>> streamProperties() {
        return Stream.concat(super.streamProperties(), PROPERTIES.stream());
    }

    public void setCalendar(FullCalendar calendar) {
        if (calendar != null && !(calendar instanceof Scheduler)) {
            throw new IllegalArgumentException("ResourceEntries must be added to a FullCalendar that implements Scheduler");
        }
        super.setCalendar(calendar);
    }

    public Optional<Resource> getResource() {
        return this.getResourcesOrEmpty().stream().findFirst();
    }

    public Set<Resource> getResourcesOrEmpty() {
        Set<Resource> resources = this.getOrCreateResources();
        return resources != null ? Collections.unmodifiableSet(resources) : Collections.emptySet();
    }

    public Set<Resource> getOrCreateResources() {
        if (this.resources == null) {
            this.resources = new LinkedHashSet<Resource>();
        }
        return this.resources;
    }

    public Set<Resource> getResources() {
        return this.resources;
    }

    public int getResourcesSize() {
        return this.getResourcesOrEmpty().size();
    }

    public boolean hasResources() {
        return !this.getResourcesOrEmpty().isEmpty();
    }

    @Deprecated(forRemoval=true)
    public void assignResources(Resource ... resources) {
        this.addResources(resources);
    }

    @Deprecated(forRemoval=true)
    public void assignResource(Resource resource) {
        this.addResources(Objects.requireNonNull(resource));
    }

    public void addResources(Resource ... resources) {
        this.addResources(Arrays.asList(resources));
    }

    public void addResources(Collection<Resource> resources) {
        Objects.requireNonNull(resources);
        this.getOrCreateResources().addAll(resources);
    }

    public void removeResources(Resource ... resources) {
        this.removeResources(Arrays.asList(resources));
    }

    public void removeResources(Collection<Resource> resources) {
        if (this.hasResources()) {
            this.getOrCreateResources().removeAll(resources);
        }
    }

    @Deprecated(forRemoval=true)
    public void unassignAllResources() {
        this.removeAllResources();
    }

    public void removeAllResources() {
        this.setResources(null);
    }

    public ObjectNode toJson() {
        return super.toJson();
    }

    @Generated
    public boolean isResourceEditable() {
        return this.resourceEditable;
    }

    @Generated
    public void setResourceEditable(boolean resourceEditable) {
        this.resourceEditable = resourceEditable;
    }

    @Generated
    public void setResources(Set<Resource> resources) {
        this.resources = resources;
    }

    @Generated
    public ResourceEntry() {
    }
}

