/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.vaadin.stefan.fullcalendar.CalendarView;
import org.vaadin.stefan.fullcalendar.EntryDroppedSchedulerEvent;
import org.vaadin.stefan.fullcalendar.FullCalendar;
import org.vaadin.stefan.fullcalendar.GroupEntriesBy;
import org.vaadin.stefan.fullcalendar.JsonFactory;
import org.vaadin.stefan.fullcalendar.Resource;
import org.vaadin.stefan.fullcalendar.ResourceEntry;
import org.vaadin.stefan.fullcalendar.Scheduler;
import org.vaadin.stefan.fullcalendar.SchedulerView;
import org.vaadin.stefan.fullcalendar.TimeslotClickedEvent;
import org.vaadin.stefan.fullcalendar.TimeslotClickedSchedulerEvent;
import org.vaadin.stefan.fullcalendar.TimeslotsSelectedEvent;
import org.vaadin.stefan.fullcalendar.TimeslotsSelectedSchedulerEvent;
import org.vaadin.stefan.fullcalendar.dataprovider.EntryProvider;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

@NpmPackage.Container(value={@NpmPackage(value="@fullcalendar/resource", version="6.1.9"), @NpmPackage(value="@fullcalendar/resource-timeline", version="6.1.9"), @NpmPackage(value="@fullcalendar/resource-timegrid", version="6.1.9"), @NpmPackage(value="@fullcalendar/resource-daygrid", version="6.1.9"), @NpmPackage(value="@fullcalendar/scrollgrid", version="6.1.9")})
@JsModule(value="./vaadin-full-calendar/full-calendar-scheduler.ts")
@CssImport(value="./vaadin-full-calendar/full-calendar-scheduler-styles.css")
@Tag(value="vaadin-full-calendar-scheduler")
public class FullCalendarScheduler
extends FullCalendar
implements Scheduler {
    public static final String FC_SCHEDULER_CLIENT_VERSION = "6.1.9";
    private final Map<String, Resource> resources = new HashMap<String, Resource>();

    public FullCalendarScheduler() {
    }

    @Deprecated(forRemoval=true)
    public FullCalendarScheduler(int entryLimit) {
        super(entryLimit);
    }

    public FullCalendarScheduler(ObjectNode initialOptions) {
        super(initialOptions);
    }

    @Override
    public void setSchedulerLicenseKey(String schedulerLicenseKey) {
        this.setOption(SchedulerOption.LICENSE_KEY, (Serializable)((Object)schedulerLicenseKey));
    }

    @Override
    public void setResourceAreaHeaderContent(String resourceAreaHeaderContent) {
        this.setOption(SchedulerOption.RESOURCE_AREA_HEADER_CONTENT, (Serializable)((Object)resourceAreaHeaderContent));
    }

    @Override
    public void setResourceAreaWidth(String resourceAreaWidth) {
        this.setOption(SchedulerOption.RESOURCE_AREA_WIDTH, (Serializable)((Object)resourceAreaWidth));
    }

    @Override
    public void setSlotMinWidth(String slotMinWidth) {
        this.setOption(SchedulerOption.SLOT_MIN_WIDTH, (Serializable)((Object)slotMinWidth));
    }

    @Override
    public void setResourcesInitiallyExpanded(boolean resourcesInitiallyExpanded) {
        this.setOption(SchedulerOption.RESOURCES_INITIALLY_EXPANDED, Boolean.valueOf(resourcesInitiallyExpanded));
    }

    @Override
    public void setFilterResourcesWithEvents(boolean filterResourcesWithEvents) {
        this.setOption(SchedulerOption.FILTER_RESOURCES_WITH_ENTRIES, Boolean.valueOf(filterResourcesWithEvents));
    }

    @Override
    public void setResourceOrder(String resourceOrder) {
        this.setOption(SchedulerOption.RESOURCE_ORDER, (Serializable)((Object)resourceOrder));
    }

    @Override
    public void setEntryResourceEditable(boolean eventResourceEditable) {
        this.setOption(SchedulerOption.ENTRY_RESOURCES_EDITABLE, Boolean.valueOf(eventResourceEditable));
    }

    @Override
    public void addResources(Iterable<Resource> iterableResource) {
        this.addResources(iterableResource, true);
    }

    @Override
    public void addResources(Iterable<Resource> iterableResource, boolean scrollToLast) {
        Objects.requireNonNull(iterableResource);
        ArrayNode array = JsonFactory.createArray();
        iterableResource.forEach(resource -> {
            String id = resource.getId();
            if (!this.resources.containsKey(id)) {
                this.resources.put(id, (Resource)resource);
                array.add((JsonNode)resource.toJson());
            }
            this.registerResourcesInternally(resource.getChildren());
        });
        this.getElement().callJsFunction("addResources", new Object[]{array, scrollToLast});
    }

    private void registerResourcesInternally(Collection<Resource> resources) {
        for (Resource resource : resources) {
            this.resources.put(resource.getId(), resource);
            this.registerResourcesInternally(resource.getChildren());
        }
    }

    @Override
    public void removeResources(Iterable<Resource> iterableResources) {
        Objects.requireNonNull(iterableResources);
        this.removeFromEntries(iterableResources);
        ArrayNode array = JsonFactory.createArray();
        iterableResources.forEach(resource -> {
            String id = resource.getId();
            if (this.resources.containsKey(id)) {
                this.resources.remove(id);
                array.add((JsonNode)resource.toJson());
            }
        });
        this.getElement().callJsFunction("removeResources", new Object[]{array});
    }

    private void removeFromEntries(Iterable<Resource> iterableResources) {
        List resources = StreamSupport.stream(iterableResources.spliterator(), false).collect(Collectors.toList());
        EntryProvider entryProvider = this.getEntryProvider();
        if (entryProvider.isInMemory()) {
            entryProvider.asInMemory().getEntries().stream().filter(e -> e instanceof ResourceEntry).forEach(e -> ((ResourceEntry)((Object)e)).removeResources(resources));
        }
    }

    @Override
    public Optional<Resource> getResourceById(String id) {
        Objects.requireNonNull(id);
        return Optional.ofNullable(this.resources.get(id));
    }

    @Override
    public Set<Resource> getResources() {
        return new LinkedHashSet<Resource>(this.resources.values());
    }

    @Override
    public void removeAllResources() {
        this.removeFromEntries(this.resources.values());
        this.resources.clear();
        this.getElement().callJsFunction("removeAllResources", new Object[0]);
    }

    @Override
    public void setResourceLabelClassNamesCallback(String s) {
        this.getElement().callJsFunction("setResourceLabelClassNamesCallback", new Object[]{s});
    }

    @Override
    public void setResourceLabelContentCallback(String s) {
        this.getElement().callJsFunction("setResourceLabelContentCallback", new Object[]{s});
    }

    @Override
    public void setResourceLabelDidMountCallback(String s) {
        this.getElement().callJsFunction("setResourceLabelDidMountCallback", new Object[]{s});
    }

    @Override
    public void setResourceLablelWillUnmountCallback(String s) {
        this.getElement().callJsFunction("setResourceLablelWillUnmountCallback", new Object[]{s});
    }

    @Override
    public void setResourceLaneClassNamesCallback(String s) {
        this.getElement().callJsFunction("setResourceLaneClassNamesCallback", new Object[]{s});
    }

    @Override
    public void setResourceLaneContentCallback(String s) {
        this.getElement().callJsFunction("setResourceLaneContentCallback", new Object[]{s});
    }

    @Override
    public void setResourceLaneDidMountCallback(String s) {
        this.getElement().callJsFunction("setResourceLaneDidMountCallback", new Object[]{s});
    }

    @Override
    public void setResourceLaneWillUnmountCallback(String s) {
        this.getElement().callJsFunction("setResourceLaneWillUnmountCallback", new Object[]{s});
    }

    @Override
    public void setGroupEntriesBy(GroupEntriesBy groupEntriesBy) {
        switch (groupEntriesBy) {
            case NONE: {
                this.setOption(SchedulerOption.GROUP_BY_RESOURCE, Boolean.valueOf(false));
                this.setOption(SchedulerOption.GROUP_BY_DATE_AND_RESOURCE, Boolean.valueOf(false));
                break;
            }
            case RESOURCE_DATE: {
                this.setOption(SchedulerOption.GROUP_BY_DATE_AND_RESOURCE, Boolean.valueOf(false));
                this.setOption(SchedulerOption.GROUP_BY_RESOURCE, Boolean.valueOf(true));
                break;
            }
            case DATE_RESOURCE: {
                this.setOption(SchedulerOption.GROUP_BY_RESOURCE, Boolean.valueOf(false));
                this.setOption(SchedulerOption.GROUP_BY_DATE_AND_RESOURCE, Boolean.valueOf(true));
            }
        }
    }

    public Registration addTimeslotsSelectedListener(ComponentEventListener<? extends TimeslotsSelectedEvent> listener) {
        return this.addTimeslotsSelectedSchedulerListener(listener);
    }

    @Override
    public Registration addTimeslotsSelectedSchedulerListener(ComponentEventListener<? extends TimeslotsSelectedSchedulerEvent> listener) {
        Objects.requireNonNull(listener);
        return this.addListener(TimeslotsSelectedSchedulerEvent.class, listener);
    }

    public Registration addTimeslotClickedListener(ComponentEventListener<? extends TimeslotClickedEvent> listener) {
        return this.addTimeslotClickedSchedulerListener(listener);
    }

    @Override
    public Registration addTimeslotClickedSchedulerListener(ComponentEventListener<? extends TimeslotClickedSchedulerEvent> listener) {
        Objects.requireNonNull(listener);
        return this.addListener(TimeslotClickedSchedulerEvent.class, listener);
    }

    @Override
    public Registration addEntryDroppedSchedulerListener(ComponentEventListener<? extends EntryDroppedSchedulerEvent> listener) {
        Objects.requireNonNull(listener);
        return this.addListener(EntryDroppedSchedulerEvent.class, listener);
    }

    public void setOption(SchedulerOption option, Serializable value) {
        this.setOption(option, value, null);
    }

    public void setOption(SchedulerOption option, Serializable value, Object valueForServerSide) {
        this.setOption(option.getOptionKey(), value, valueForServerSide);
    }

    public <T> Optional<T> getOption(SchedulerOption option) {
        return this.getOption(option, false);
    }

    public <T> Optional<T> getOption(SchedulerOption option, boolean forceClientSideValue) {
        return this.getOption(option.getOptionKey(), forceClientSideValue);
    }

    public <T extends CalendarView> Optional<T> lookupViewByClientSideValue(String clientSideValue) {
        Optional<SchedulerView> optional = super.lookupViewByClientSideValue(clientSideValue);
        if (optional.isEmpty()) {
            optional = SchedulerView.ofClientSideValue(clientSideValue);
        }
        return optional;
    }

    public static enum SchedulerOption {
        ENTRY_RESOURCES_EDITABLE("eventResourceEditable"),
        FILTER_RESOURCES_WITH_ENTRIES("filterResourcesWithEvents"),
        GROUP_BY_DATE_AND_RESOURCE("groupByDateAndResource"),
        GROUP_BY_RESOURCE("groupByResource"),
        LICENSE_KEY("schedulerLicenseKey"),
        REFETCH_RESOURCES_ON_NAVIGATE("refetchResourcesOnNavigate"),
        RESOURCE_AREA_HEADER_CONTENT("resourceAreaHeaderContent"),
        RESOURCE_AREA_WIDTH("resourceAreaWidth"),
        RESOURCES_INITIALLY_EXPANDED("resourcesInitiallyExpanded"),
        RESOURCE_ORDER("resourceOrder"),
        SLOT_MIN_WIDTH("slotMinWidth");

        private final String optionKey;

        private SchedulerOption(String optionKey) {
            this.optionKey = optionKey;
        }

        String getOptionKey() {
            return this.optionKey;
        }
    }
}

