/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar.converter;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.vaadin.stefan.fullcalendar.FullCalendarScheduler;
import org.vaadin.stefan.fullcalendar.JsonUtils;
import org.vaadin.stefan.fullcalendar.Resource;
import org.vaadin.stefan.fullcalendar.ResourceEntry;
import org.vaadin.stefan.fullcalendar.converters.JsonItemPropertyConverter;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.NullNode;

public class ResourceConverter
implements JsonItemPropertyConverter<Set<Resource>, ResourceEntry> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean supports(Object type) {
        if (!(type instanceof Set)) return false;
        if (!((Set)type).stream().allMatch(Resource.class::isInstance)) return false;
        return true;
    }

    public JsonNode toClientModel(Set<Resource> serverValue, ResourceEntry currentInstance) {
        List ids = serverValue.stream().map(Resource::getId).collect(Collectors.toList());
        return JsonUtils.toJsonNode(ids);
    }

    public Set<Resource> toServerModel(JsonNode clientValue, ResourceEntry currentInstance) {
        if (clientValue instanceof NullNode) {
            return new LinkedHashSet<Resource>();
        }
        FullCalendarScheduler calendar = (FullCalendarScheduler)currentInstance.getCalendar().orElseThrow(() -> new IllegalStateException("Converting to server model requires an assigned scheduler instance"));
        Object value = JsonUtils.ofJsonNode((JsonNode)clientValue);
        if (value instanceof List) {
            return ((List)value).stream().filter(Objects::nonNull).map(Object::toString).map(calendar::getResourceById).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        if (value instanceof String || value instanceof Number) {
            LinkedHashSet<Resource> set = new LinkedHashSet<Resource>();
            set.add(calendar.getResourceById(value.toString()).orElseThrow(() -> new NoSuchElementException("Id unknown: " + String.valueOf(value))));
            return set;
        }
        throw new IllegalStateException("Value is not supported, as it is neither a string nor a list: " + String.valueOf(value));
    }
}

