/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar;

import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.vaadin.stefan.fullcalendar.Entry;
import org.vaadin.stefan.fullcalendar.EntryTimeChangedEvent;
import org.vaadin.stefan.fullcalendar.FullCalendar;
import org.vaadin.stefan.fullcalendar.FullCalendarScheduler;
import org.vaadin.stefan.fullcalendar.Resource;
import org.vaadin.stefan.fullcalendar.ResourceEntry;
import org.vaadin.stefan.fullcalendar.Scheduler;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

@DomEvent(value="eventDrop")
public class EntryDroppedSchedulerEvent
extends EntryTimeChangedEvent {
    private final Resource oldResource;
    private final Resource newResource;

    public EntryDroppedSchedulerEvent(FullCalendarScheduler source, boolean fromClient, @EventData(value="event.detail.data") ObjectNode jsonEntry, @EventData(value="event.detail.delta") ObjectNode jsonDelta) {
        super((FullCalendar)source, fromClient, jsonEntry, jsonDelta);
        this.oldResource = jsonEntry.hasNonNull("oldResource") ? source.getResourceById(jsonEntry.get("oldResource").asString()).orElseThrow(IllegalArgumentException::new) : null;
        this.newResource = jsonEntry.has("newResource") ? source.getResourceById(jsonEntry.get("newResource").asString()).orElseThrow(IllegalArgumentException::new) : null;
    }

    public Entry applyChangesOnEntry() {
        ResourceEntry entry = (ResourceEntry)super.applyChangesOnEntry();
        ObjectNode object = this.getJsonObject();
        EntryDroppedSchedulerEvent.updateResourcesFromEventResourceDelta(entry, object);
        return entry;
    }

    public static void updateResourcesFromEventResourceDelta(ResourceEntry entry, ObjectNode object) {
        entry.getCalendar().map(c -> (Scheduler)c).ifPresent(calendar -> {
            Optional.ofNullable(object.get("oldResource")).filter(JsonNode::isString).map(JsonNode::asString).flatMap(calendar::getResourceById).map(Collections::singleton).ifPresent(entry::removeResources);
            Optional.ofNullable(object.get("newResource")).filter(JsonNode::isString).map(JsonNode::asString).flatMap(calendar::getResourceById).map(Collections::singleton).ifPresent(entry::addResources);
        });
    }

    public Optional<Resource> getOldResource() {
        return Optional.ofNullable(this.oldResource);
    }

    public Optional<Resource> getNewResource() {
        return Optional.ofNullable(this.newResource);
    }

    @Generated
    public String toString() {
        return "EntryDroppedSchedulerEvent(super=" + super.toString() + ", oldResource=" + String.valueOf(this.getOldResource()) + ", newResource=" + String.valueOf(this.getNewResource()) + ")";
    }
}

