/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.shared.Registration;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.vaadin.stefan.fullcalendar.EntryDroppedSchedulerEvent;
import org.vaadin.stefan.fullcalendar.GroupEntriesBy;
import org.vaadin.stefan.fullcalendar.Resource;
import org.vaadin.stefan.fullcalendar.TimeslotClickedSchedulerEvent;
import org.vaadin.stefan.fullcalendar.TimeslotsSelectedSchedulerEvent;

public interface Scheduler {
    public static final String DEVELOPER_LICENSE_KEY = "CC-Attribution-NonCommercial-NoDerivatives";
    public static final String NON_COMMERCIAL_CREATIVE_COMMONS_LICENSE_KEY = "CC-Attribution-NonCommercial-NoDerivatives";
    public static final String GPL_V3_LICENSE_KEY = "GPL-My-Project-Is-Open-Source";

    public void setSchedulerLicenseKey(String var1);

    public void setResourceAreaHeaderContent(String var1);

    public void setResourceAreaWidth(String var1);

    public void setSlotMinWidth(String var1);

    public void setResourcesInitiallyExpanded(boolean var1);

    public void setFilterResourcesWithEvents(boolean var1);

    public void setResourceOrder(String var1);

    public void setEntryResourceEditable(boolean var1);

    default public void addResource(Resource resource, boolean scrollToLast) {
        Objects.requireNonNull(resource);
        this.addResources(Collections.singletonList(resource), scrollToLast);
    }

    default public void addResource(Resource resource) {
        Objects.requireNonNull(resource);
        this.addResources(Collections.singletonList(resource));
    }

    default public void addResources(boolean scrollToLast, Resource ... resources) {
        this.addResources(Arrays.asList(resources), scrollToLast);
    }

    default public void addResources(Resource ... resources) {
        this.addResources(Arrays.asList(resources));
    }

    public void addResources(Iterable<Resource> var1, boolean var2);

    public void addResources(Iterable<Resource> var1);

    default public void removeResource(Resource resource) {
        Objects.requireNonNull(resource);
        this.removeResources(Collections.singletonList(resource));
    }

    default public void removeResources(Resource ... resources) {
        this.removeResources(Arrays.asList(resources));
    }

    public void removeResources(Iterable<Resource> var1);

    public Optional<Resource> getResourceById(String var1);

    public Set<Resource> getResources();

    default public Set<Resource> getTopLevelResources() {
        return this.getResources().stream().filter(r -> !r.getParent().isPresent()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public void removeAllResources();

    public void setResourceLabelClassNamesCallback(String var1);

    public void setResourceLabelContentCallback(String var1);

    public void setResourceLabelDidMountCallback(String var1);

    public void setResourceLablelWillUnmountCallback(String var1);

    public void setResourceLaneClassNamesCallback(String var1);

    public void setResourceLaneContentCallback(String var1);

    public void setResourceLaneDidMountCallback(String var1);

    public void setResourceLaneWillUnmountCallback(String var1);

    public void setGroupEntriesBy(GroupEntriesBy var1);

    public Registration addEntryDroppedSchedulerListener(ComponentEventListener<? extends EntryDroppedSchedulerEvent> var1);

    public Registration addTimeslotClickedSchedulerListener(ComponentEventListener<? extends TimeslotClickedSchedulerEvent> var1);

    public Registration addTimeslotsSelectedSchedulerListener(ComponentEventListener<? extends TimeslotsSelectedSchedulerEvent> var1);
}

