/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.vaadin.stefan.fullcalendar.BusinessHours;
import org.vaadin.stefan.fullcalendar.JsonFactory;
import org.vaadin.stefan.fullcalendar.JsonUtils;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public class Resource {
    private final String id;
    private final String title;
    private final String color;
    private final BusinessHours[] businessHoursArray;
    private Set<Resource> children;
    private Resource parent;
    private final HashMap<String, Object> extendedProps = new HashMap();

    public Resource() {
        this(null, null, null);
    }

    public Resource(String id, String title, String color) {
        this(id, title, color, null, new BusinessHours[0]);
    }

    public Resource(String id, String title, String color, Collection<Resource> children, BusinessHours ... businessHours) {
        this.id = id != null ? id : UUID.randomUUID().toString();
        this.title = title;
        this.color = color;
        Object object = this.businessHoursArray = businessHours != null && businessHours.length == 0 ? null : businessHours;
        if (children != null) {
            this.addChildren(children);
        }
    }

    public Set<Resource> getChildren() {
        return this.children != null ? Collections.unmodifiableSet(this.children) : Collections.emptySet();
    }

    public void addChild(Resource child) {
        this.addChildren(Objects.requireNonNull(child));
    }

    public void addChildren(Collection<Resource> children) {
        Objects.requireNonNull(children);
        if (this.children == null) {
            this.children = new LinkedHashSet<Resource>(children);
        } else {
            this.children.addAll(children);
        }
        children.forEach(child -> {
            child.getParent().ifPresent(p -> p.children.remove(child));
            child.setParent(this);
        });
    }

    public void addChildren(Resource ... children) {
        this.addChildren(Arrays.asList(children));
    }

    public void removeChild(Resource child) {
        this.removeChildren(Objects.requireNonNull(child));
    }

    public void removeChildren(Resource ... children) {
        this.removeChildren(Arrays.asList(children));
    }

    public void removeChildren(Collection<Resource> children) {
        children.stream().filter(child -> {
            Optional<Resource> parent = child.getParent();
            return parent.isPresent() && parent.get().equals(this);
        }).forEach(child -> child.setParent(null));
        this.children.removeAll(children);
    }

    public void addExtendedProps(String key, Object value) {
        this.extendedProps.put(key, value);
    }

    public void removeExtendedProps(String key) {
        this.extendedProps.remove(key);
    }

    public void removeExtendedProps(String key, Object value) {
        this.extendedProps.remove(key, value);
    }

    protected ObjectNode toJson() {
        HashMap<String, Object> extendedProps;
        ObjectNode jsonObject = JsonFactory.createObject();
        jsonObject.put("id", this.getId());
        jsonObject.set("title", JsonUtils.toJsonNode((Object)this.getTitle()));
        jsonObject.set("eventColor", JsonUtils.toJsonNode((Object)this.getColor()));
        BusinessHours[] businessHours = this.getBusinessHoursArray();
        if (businessHours != null && businessHours.length > 0) {
            ArrayNode businessHoursJsonArray = JsonFactory.createArray();
            for (BusinessHours hour : businessHours) {
                businessHoursJsonArray.add((JsonNode)hour.toJson());
            }
            jsonObject.set("businessHours", (JsonNode)businessHoursJsonArray);
        }
        this.getParent().ifPresent(parent -> jsonObject.put("parentId", parent.getId()));
        Set<Resource> children = this.getChildren();
        if (!children.isEmpty()) {
            ArrayNode jsonArray = JsonFactory.createArray();
            for (Resource child : children) {
                jsonArray.add((JsonNode)child.toJson());
            }
            jsonObject.set("children", (JsonNode)jsonArray);
        }
        if (!(extendedProps = this.getExtendedProps()).isEmpty()) {
            for (Map.Entry<String, Object> prop : extendedProps.entrySet()) {
                jsonObject.set(prop.getKey(), JsonUtils.toJsonNode((Object)prop.getValue()));
            }
        }
        return jsonObject;
    }

    public Optional<Resource> getParent() {
        return Optional.ofNullable(this.parent);
    }

    private void setParent(Resource parent) {
        this.parent = parent;
    }

    public BusinessHours getBusinessHours() {
        if (this.businessHoursArray == null || this.businessHoursArray.length == 0) {
            return null;
        }
        return this.businessHoursArray[0];
    }

    public String toString() {
        String s = "Resource{title='" + this.title + "', color='" + this.color + "', id='" + this.id + "', children='" + String.valueOf(this.children) + "'";
        if (this.parent != null) {
            s = s + "parentId = '" + this.parent.getId() + "'";
        }
        return s + "}";
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getColor() {
        return this.color;
    }

    @Generated
    public BusinessHours[] getBusinessHoursArray() {
        return this.businessHoursArray;
    }

    @Generated
    public HashMap<String, Object> getExtendedProps() {
        return this.extendedProps;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Resource;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

