/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.olli;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.littemplate.LitTemplate;
import com.vaadin.flow.component.template.Id;

@Tag(value="clipboard-helper")
@JsModule(value="./clipboard-helper.js")
public class ClipboardHelper
extends LitTemplate {
    @Id(value="wrapper")
    private Div componentWrapper;

    public ClipboardHelper(String content, Component component) {
        this.setContent(content);
        this.wrap(component);
    }

    public ClipboardHelper() {
    }

    public void wrap(Component component) {
        this.componentWrapper.removeAll();
        this.componentWrapper.add(new Component[]{component});
    }

    public void setContent(String content) {
        this.getModel().setContent(content);
    }

    private ClipboardHelperModel getModel() {
        return new ClipboardHelperModel(){

            @Override
            public void setContent(String content) {
                ClipboardHelper.this.getElement().setProperty("content", content);
            }

            @Override
            public String getContent() {
                return ClipboardHelper.this.getElement().getProperty("content", null);
            }
        };
    }

    public static interface ClipboardHelperModel {
        public String getContent();

        public void setContent(String var1);
    }
}

