/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.tltv.gantt.util;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import org.vaadin.tltv.gantt.model.Resolution;

public class GanttUtil {
    private static final String DATE_TIME_PATTERN = "yyyy-MM-dd'T'HH':'mm':'ss";
    private static final String DATE_HOUR_PATTERN = "yyyy-MM-dd'T'HH";
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH':'mm':'ss");
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter dateHourFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH");

    public static String formatDateTime(TemporalAccessor temporal) {
        return dateTimeFormatter.format(temporal);
    }

    public static TemporalAccessor parseDateTime(CharSequence text) {
        return dateTimeFormatter.parse(text);
    }

    public static String formatDate(TemporalAccessor temporal) {
        return dateFormatter.format(temporal);
    }

    public static TemporalAccessor parseDate(CharSequence text) {
        return dateFormatter.parse(text);
    }

    public static String formatDateHour(TemporalAccessor temporal) {
        return dateHourFormatter.format(temporal);
    }

    public static TemporalAccessor parseDateHour(CharSequence text) {
        return dateHourFormatter.parse(text);
    }

    public static TemporalAccessor parse(CharSequence text) {
        if (text.length() > 13) {
            return GanttUtil.parseDateTime(text);
        }
        if (text.length() > 10) {
            return GanttUtil.parseDateHour(text);
        }
        return GanttUtil.parseDate(text);
    }

    public static LocalDateTime parseLocalDateTime(CharSequence text) {
        return LocalDateTime.from(GanttUtil.parseDateTime(text.subSequence(0, 19)));
    }

    public static LocalDateTime resetTimeToMin(LocalDateTime dateTime, Resolution resolution) {
        if (Objects.isNull(dateTime)) {
            return null;
        }
        if (Resolution.Hour.equals((Object)resolution)) {
            return dateTime.truncatedTo(ChronoUnit.HOURS);
        }
        return dateTime.truncatedTo(ChronoUnit.DAYS);
    }

    public static LocalDateTime resetTimeToMax(LocalDateTime dateTime, Resolution resolution, boolean exclusive) {
        if (Objects.isNull(dateTime)) {
            return null;
        }
        if (Resolution.Hour.equals((Object)resolution)) {
            if (exclusive) {
                dateTime = dateTime.minusHours(1L);
            }
            return dateTime.plusHours(1L).truncatedTo(ChronoUnit.HOURS).minusSeconds(1L);
        }
        if (exclusive) {
            dateTime = dateTime.minusDays(1L);
        }
        return dateTime.plusDays(1L).truncatedTo(ChronoUnit.DAYS).minusSeconds(1L);
    }
}

