/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.tltv.gantt.event;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import java.time.LocalDateTime;
import org.vaadin.tltv.gantt.Gantt;
import org.vaadin.tltv.gantt.model.GanttStep;
import org.vaadin.tltv.gantt.util.GanttUtil;

@DomEvent(value="ganttStepMove")
public class StepMoveEvent
extends ComponentEvent<Gantt> {
    private final String uid;
    private final String newUid;
    private final LocalDateTime start;
    private final LocalDateTime end;

    public StepMoveEvent(Gantt source, boolean fromClient, @EventData(value="event.detail.uid") String uid, @EventData(value="event.detail.newUid") String newUid, @EventData(value="event.detail.start") String start, @EventData(value="event.detail.end") String end) {
        super((Component)source, fromClient);
        this.uid = uid;
        this.newUid = newUid;
        this.start = GanttUtil.parseLocalDateTime(start);
        this.end = GanttUtil.parseLocalDateTime(end);
    }

    public GanttStep getAnyStep() {
        return ((Gantt)this.getSource()).getAnyStep(this.uid);
    }

    public LocalDateTime getStart() {
        return this.start;
    }

    public LocalDateTime getEnd() {
        return this.end;
    }

    public String getNewUid() {
        return this.newUid;
    }
}

