/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.tltv.gantt.element;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.contextmenu.ContextMenu;
import com.vaadin.flow.component.shared.Tooltip;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.vaadin.tltv.gantt.model.GanttStep;
import org.vaadin.tltv.gantt.model.Resolution;
import org.vaadin.tltv.gantt.util.GanttUtil;

@Tag(value="gantt-step-element")
public class StepElement
extends Component
implements HasComponents {
    private final String uid;
    private GanttStep model;
    private final List<BiConsumer<ContextMenu, String>> contextMenuBuilders = new ArrayList<BiConsumer<ContextMenu, String>>();
    private final List<Registration> contextMenuDomListenerRegistrations = new ArrayList<Registration>();
    private final List<Tooltip> tooltips = new ArrayList<Tooltip>();

    public StepElement(GanttStep model) {
        this.model = model;
        this.uid = model.getUid();
        this.getElement().setProperty("uid", this.uid);
        this.refresh();
    }

    public void refresh() {
        this.setCaption(this.model.getCaption());
        this.setBackgroundColor(this.model.getBackgroundColor());
        this.setStartDateTime(this.model.getStartDate());
        this.setEndDateTime(this.model.getEndDate());
    }

    public String getUid() {
        return this.uid;
    }

    public GanttStep getModel() {
        return this.model;
    }

    public void setCaption(String caption) {
        this.getElement().setAttribute("caption", caption);
    }

    public String getCaption() {
        return this.getElement().getAttribute("caption");
    }

    public void setBackgroundColor(String backgroundColor) {
        this.getElement().setAttribute("backgroundColor", backgroundColor);
    }

    public String getBackgroundColor() {
        return this.getElement().getAttribute("backgroundColor");
    }

    public void setStartDateTime(LocalDateTime startDateTime) {
        this.getElement().setAttribute("start", GanttUtil.formatDateTime(GanttUtil.resetTimeToMin(startDateTime, Resolution.Hour)));
    }

    public LocalDateTime getStartDateTime() {
        return GanttUtil.parseLocalDateTime(this.getElement().getAttribute("start"));
    }

    public void setEndDateTime(LocalDateTime endDateTime) {
        this.getElement().setAttribute("end", GanttUtil.formatDateTime(GanttUtil.resetTimeToMin(endDateTime, Resolution.Hour)));
    }

    public LocalDateTime getEndDateTime() {
        return GanttUtil.parseLocalDateTime(this.getElement().getAttribute("end"));
    }

    public void removeFromParent() {
        this.contextMenuDomListenerRegistrations.forEach(Registration::remove);
        this.getElement().removeFromParent();
    }

    public void addContextMenu(final BiConsumer<ContextMenu, String> builder) {
        this.contextMenuBuilders.add(builder);
        ContextMenu contextMenu = new ContextMenu();
        contextMenu.setTarget((Component)this);
        final DomListenerRegistration reg = this.getElement().addEventListener("vaadin-context-menu-before-open", (DomEventListener & Serializable)event -> builder.accept(contextMenu, event.getEventData().get("element.uid").asString())).addEventData("element.uid");
        this.contextMenuDomListenerRegistrations.add(new Registration(){
            private static final long serialVersionUID = 7711223599693115951L;

            public void remove() {
                reg.remove();
                StepElement.this.contextMenuBuilders.remove(builder);
            }
        });
    }

    public List<BiConsumer<ContextMenu, String>> getContextMenuBuilders() {
        return this.contextMenuBuilders.stream().collect(Collectors.toList());
    }

    public Tooltip addTooltip() {
        return this.addTooltip((String)null);
    }

    public Tooltip addTooltip(String text) {
        Tooltip tooltip = Tooltip.forComponent((Component)this).withText(text);
        tooltip.setPosition(Tooltip.TooltipPosition.TOP_START);
        this.tooltips.add(tooltip);
        return tooltip;
    }

    public Tooltip addTooltip(Tooltip tooltip) {
        Tooltip newTooltip = this.addTooltip(tooltip.getText());
        newTooltip.setPosition(tooltip.getPosition());
        newTooltip.setFocusDelay(tooltip.getFocusDelay());
        newTooltip.setHideDelay(tooltip.getHideDelay());
        newTooltip.setHoverDelay(tooltip.getHoverDelay());
        newTooltip.setManual(tooltip.isManual());
        return newTooltip;
    }

    public List<Tooltip> getTooltips() {
        return Collections.unmodifiableList(this.tooltips);
    }
}

