/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.tltv.gantt;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.treegrid.TreeGrid;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.data.provider.hierarchy.TreeDataProvider;
import com.vaadin.flow.data.renderer.LitRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.vaadin.tltv.gantt.element.StepElement;
import org.vaadin.tltv.gantt.event.GanttClickEvent;
import org.vaadin.tltv.gantt.event.GanttDataChangeEvent;
import org.vaadin.tltv.gantt.event.StepClickEvent;
import org.vaadin.tltv.gantt.event.StepMoveEvent;
import org.vaadin.tltv.gantt.event.StepResizeEvent;
import org.vaadin.tltv.gantt.model.GanttStep;
import org.vaadin.tltv.gantt.model.Resolution;
import org.vaadin.tltv.gantt.model.Step;
import org.vaadin.tltv.gantt.model.SubStep;
import org.vaadin.tltv.gantt.util.GanttUtil;
import tools.jackson.databind.node.ArrayNode;

@Tag(value="gantt-element")
@NpmPackage.Container(value={@NpmPackage(value="tltv-gantt-element", version="1.0.30"), @NpmPackage(value="tltv-timeline-element", version="1.0.20"), @NpmPackage(value="date-fns", version="4.1.0"), @NpmPackage(value="date-fns-tz", version="3.0.0")})
@JsModule(value="tltv-gantt-element/dist/src/gantt-element.js")
@CssImport(value="gantt-grid.css", themeFor="vaadin-grid")
public class Gantt
extends Component
implements HasSize {
    private Grid<Step> captionGrid;
    private Registration captionGridDataChangeListener;
    private Registration captionGridColumnResizeListener;
    private final Set<ComponentEventListener<StepMoveEvent>> moveListeners = new HashSet<ComponentEventListener<StepMoveEvent>>();

    public Gantt() {
        this.setupDefaults();
        this.addListener(StepMoveEvent.class, (ComponentEventListener & Serializable)event -> {
            event.getAnyStep().setStartDate(event.getStart());
            event.getAnyStep().setEndDate(event.getEnd());
            this.moveStep(this.indexOf(event.getNewUid()), event.getAnyStep(), true);
            this.fireMoveListeners((StepMoveEvent)event);
        });
    }

    public void setupDefaults() {
        this.setResolution(Resolution.Day);
        this.setLocale(super.getLocale());
        this.setTimeZone(TimeZone.getTimeZone("Europe/London"));
        this.setStartDate(LocalDate.now());
        this.setEndDate(LocalDate.now().plusMonths(1L));
    }

    public void setResolution(Resolution resolution) {
        this.getElement().setAttribute("resolution", Objects.requireNonNull(resolution, "Setting null Resolution is not allowed").name());
        this.refreshForHorizontalScrollbar();
    }

    public Resolution getResolution() {
        return Resolution.valueOf(this.getElement().getAttribute("resolution"));
    }

    public void setLocale(Locale locale) {
        this.getElement().setAttribute("locale", Objects.requireNonNull(locale, "Setting null Locale is not allowed").toLanguageTag());
        this.setupByLocale();
    }

    public Locale getLocale() {
        return Locale.forLanguageTag(this.getElement().getAttribute("locale"));
    }

    public void setTimeZone(TimeZone timeZone) {
        this.getElement().setAttribute("zone", Objects.requireNonNull(timeZone, "Setting null TimeZone is not allowed").getID());
    }

    public TimeZone getTimeZone() {
        return TimeZone.getTimeZone(this.getElement().getAttribute("zone"));
    }

    public void setStartDate(LocalDate startDate) {
        Objects.requireNonNull(startDate, "Setting null start date is not allowed");
        this.getElement().setAttribute("start", GanttUtil.formatDate(this.resetTimeToMin(startDate.atStartOfDay())));
    }

    public void setStartDateTime(LocalDateTime startDateTime) {
        Objects.requireNonNull(startDateTime, "Setting null start date time is not allowed");
        this.getElement().setAttribute("start", GanttUtil.formatDateHour(this.resetTimeToMin(startDateTime)));
    }

    public LocalDate getStartDate() {
        return LocalDate.from(GanttUtil.parseDate(this.getElement().getAttribute("start")));
    }

    public LocalDateTime getStartDateTime() {
        if (this.getResolution() == Resolution.Hour) {
            return LocalDateTime.from(GanttUtil.parse(this.getElement().getAttribute("start")));
        }
        return LocalDateTime.of(this.getStartDate(), LocalTime.MIN);
    }

    public void setEndDate(LocalDate endDate) {
        Objects.requireNonNull(endDate, "Setting null end date is not allowed");
        this.getElement().setAttribute("end", GanttUtil.formatDate(this.resetTimeToMin(endDate.atStartOfDay())));
    }

    public void setEndDateTime(LocalDateTime endDateTime) {
        Objects.requireNonNull(endDateTime, "Setting null end date time is not allowed");
        this.getElement().setAttribute("end", GanttUtil.formatDateHour(this.resetTimeToMin(endDateTime)));
    }

    public LocalDate getEndDate() {
        return LocalDate.from(GanttUtil.parse(this.getElement().getAttribute("end")));
    }

    public LocalDateTime getEndDateTime() {
        if (this.getResolution() == Resolution.Hour) {
            return LocalDateTime.from(GanttUtil.parse(this.getElement().getAttribute("end")));
        }
        return LocalDateTime.of(this.getEndDate(), LocalTime.MIN);
    }

    public boolean isTwelveHourClock() {
        return this.getElement().getProperty("twelveHourClock", false);
    }

    public void setTwelveHourClock(boolean enabled) {
        this.getElement().setProperty("twelveHourClock", enabled);
    }

    public void setYearRowVisible(boolean visible) {
        this.getElement().setProperty("yearRowVisible", visible);
        this.refreshForHorizontalScrollbar();
    }

    public boolean isYearRowVisible() {
        return this.getElement().getProperty("yearRowVisible", true);
    }

    public void setMonthRowVisible(boolean visible) {
        this.getElement().setProperty("monthRowVisible", visible);
        this.refreshForHorizontalScrollbar();
    }

    public boolean isMonthRowVisible() {
        return this.getElement().getProperty("monthRowVisible", true);
    }

    public void setMovableSteps(boolean enabled) {
        this.getElement().setProperty("movableSteps", enabled);
    }

    public boolean isMovableSteps() {
        return this.getElement().getProperty("movableSteps", true);
    }

    public void setResizableSteps(boolean enabled) {
        this.getElement().setProperty("resizableSteps", enabled);
    }

    public boolean isResizableSteps() {
        return this.getElement().getProperty("resizableSteps", true);
    }

    public void setMovableStepsBetweenRows(boolean enabled) {
        this.getElement().setProperty("movableStepsBetweenRows", enabled);
    }

    public boolean isMovableStepsBetweenRows() {
        return this.getElement().getProperty("movableStepsBetweenRows", true);
    }

    public void addSteps(Collection<Step> steps) {
        if (steps != null) {
            this.addSteps(steps.stream());
        }
    }

    public void addSteps(Step ... steps) {
        if (steps != null) {
            this.addSteps(Stream.of(steps));
        }
    }

    public void addSteps(Stream<Step> steps) {
        if (steps == null) {
            return;
        }
        List<Step> list = steps.toList();
        steps.forEach(this::appendStep);
        this.fireDataChangeEvent(GanttDataChangeEvent.DataEvent.STEP_ADD, list.stream());
    }

    public void addStep(Step step) {
        this.appendStep(step);
        this.fireDataChangeEvent(GanttDataChangeEvent.DataEvent.STEP_ADD, Stream.of(step));
    }

    public void addSubStep(SubStep subStep) {
        StepElement ownerStepElement = (StepElement)((Object)this.getStepElements().collect(Collectors.toList()).get(this.indexOf(subStep.getOwner().getUid())));
        ownerStepElement.getElement().appendChild(new Element[]{new StepElement(this.ensureUID(subStep)).getElement()});
    }

    private void addSubStepElement(StepElement subStepElement) {
        StepElement ownerStepElement = (StepElement)((Object)this.getStepElements().collect(Collectors.toList()).get(this.indexOf(((SubStep)subStepElement.getModel()).getOwner().getUid())));
        ownerStepElement.getElement().appendChild(new Element[]{subStepElement.getElement()});
    }

    public void addStep(int index, Step step) {
        this.addStep(index, step, true);
    }

    private void addStep(int index, Step step, boolean fireDataEvent) {
        if (this.contains(this.ensureUID(step))) {
            this.moveStep(index, step);
        } else {
            this.getElement().insertChild(index, new Element[]{new StepElement(this.ensureUID(step)).getElement()});
            if (fireDataEvent) {
                this.fireDataChangeEvent(GanttDataChangeEvent.DataEvent.STEP_ADD, Stream.of(step));
            }
        }
    }

    public void moveStep(int toIndex, GanttStep anyStep) {
        this.moveStep(toIndex, anyStep, false);
    }

    private void moveStep(int toIndex, GanttStep anyStep, boolean fromClient) {
        if (anyStep.isSubstep()) {
            this.moveSubStep(toIndex, (SubStep)anyStep);
        } else {
            this.moveStep(toIndex, (Step)anyStep, fromClient);
        }
    }

    public void moveStep(int toIndex, Step step) {
        this.moveStep(toIndex, step, false);
    }

    private void moveStep(int toIndex, Step step, boolean fromClient) {
        if (!this.contains(step)) {
            return;
        }
        String targetStepUid = ((StepElement)((Object)this.getStepElements().collect(Collectors.toList()).get(toIndex))).getUid();
        int fromIndex = this.indexOf(step);
        Step moveStep = step;
        if (!targetStepUid.equals(moveStep.getUid())) {
            List<Step> flatSubTree;
            if (this.getCaptionTreeGrid() != null && (flatSubTree = this.getFlatSubTreeRecursively((TreeData<Step>)this.getCaptionTreeGrid().getTreeData(), step)).contains(this.getStep(targetStepUid))) {
                this.doMoveStep(this.indexOf(moveStep.getUid()), moveStep.getUid(), moveStep);
                this.updateSubStepsByMovedOwner(moveStep.getUid());
                return;
            }
            this.doMoveStep(fromIndex, targetStepUid, moveStep);
            if (fromClient) {
                this.fireDataChangeEvent(GanttDataChangeEvent.DataEvent.STEP_MOVE, Stream.of(step));
            }
        }
        this.updateSubStepsByMovedOwner(moveStep.getUid());
    }

    private void doMoveStep(int fromIndex, String targetStepUid, Step moveStep) {
        int toIndex = this.indexOf(targetStepUid);
        Stream<StepElement> subStepEements = this.getSubStepElements(moveStep.getUid());
        List contextMenuBuilders = this.getStepElementOptional(moveStep.getUid()).map(StepElement::getContextMenuBuilders).orElse(List.of());
        List tooltips = this.getStepElementOptional(moveStep.getUid()).map(StepElement::getTooltips).orElse(List.of());
        List components = this.getStepElementOptional(moveStep.getUid()).map(Component::getChildren).orElse(Stream.empty()).toList();
        this.getStepElementOptional(moveStep.getUid()).ifPresent(StepElement::removeFromParent);
        StepElement stepElement = new StepElement(moveStep);
        subStepEements.forEach(subStepElement -> stepElement.getElement().appendChild(new Element[]{subStepElement.getElement()}));
        if (targetStepUid.equals(moveStep.getUid())) {
            this.getElement().insertChild(toIndex, new Element[]{stepElement.getElement()});
        } else if (fromIndex <= toIndex) {
            this.getElement().insertChild(this.indexOf(targetStepUid) + 1, new Element[]{stepElement.getElement()});
        } else {
            this.getElement().insertChild(this.indexOf(targetStepUid), new Element[]{stepElement.getElement()});
        }
        contextMenuBuilders.stream().forEach(stepElement::addContextMenu);
        tooltips.forEach(stepElement::addTooltip);
        stepElement.add(components);
    }

    public void moveSubStep(int toIndex, SubStep subStep) {
        if (!this.contains(subStep)) {
            return;
        }
        String targetStepUid = ((StepElement)((Object)this.getStepElements().collect(Collectors.toList()).get(toIndex))).getUid();
        StepElement stepElement = this.getStepElement(targetStepUid);
        Step moveStep = subStep.getOwner();
        if (!targetStepUid.equals(moveStep.getUid())) {
            StepElement substepElement = this.getSubStepElements().filter(item -> item.getUid().equals(subStep.getUid())).findFirst().orElse(null);
            List contextMenuBuilders = Optional.ofNullable(substepElement).map(StepElement::getContextMenuBuilders).orElse(List.of());
            List tooltips = Optional.ofNullable(substepElement).map(StepElement::getTooltips).orElse(List.of());
            List components = Optional.ofNullable(substepElement).map(Component::getChildren).orElse(Stream.empty()).toList();
            this.getSubStepElements().filter(item -> item.getUid().equals(subStep.getUid())).findFirst().ifPresent(StepElement::removeFromParent);
            subStep.setOwner(this.getStep(targetStepUid));
            substepElement = new StepElement(subStep);
            stepElement.getElement().appendChild(new Element[]{substepElement.getElement()});
            contextMenuBuilders.stream().forEach(substepElement::addContextMenu);
            tooltips.forEach(substepElement::addTooltip);
            substepElement.add(components);
        }
        subStep.updateOwnerDatesBySubStep();
        stepElement.refresh();
    }

    public void removeSteps(Collection<Step> steps) {
        if (steps != null) {
            this.removeSteps(steps.stream());
        }
    }

    public void removeSteps(Step ... steps) {
        if (steps != null) {
            this.removeSteps(Stream.of(steps));
        }
    }

    public void removeSteps(Stream<Step> steps) {
        if (steps == null) {
            return;
        }
        List<Step> list = steps.toList();
        list.forEach(step -> this.doRemoveStep((Step)step, true));
    }

    public boolean removeAnyStep(String uid) {
        return this.doRemoveAnyStep(uid, true);
    }

    public boolean removeAnyStep(GanttStep step) {
        return this.doRemoveAnyStep(step.getUid(), true);
    }

    public boolean removeStep(Step step) {
        return this.doRemoveStep(step, true);
    }

    private boolean doRemoveStep(Step step, boolean fireDataEvent) {
        return this.doRemoveAnyStep(step.getUid(), fireDataEvent);
    }

    private boolean doRemoveAnyStep(String uid, boolean fireDataEvent) {
        StepElement removedStepElement = this.getStepElement(uid);
        if (removedStepElement != null) {
            removedStepElement.removeFromParent();
            if (removedStepElement.getModel().isSubstep()) {
                this.refresh(((SubStep)removedStepElement.getModel()).getOwner().getUid());
            } else if (fireDataEvent) {
                this.fireDataChangeEvent(GanttDataChangeEvent.DataEvent.STEP_REMOVE, Stream.of((Step)removedStepElement.getModel()));
            }
            return true;
        }
        return false;
    }

    private void appendStep(Step step) {
        this.getElement().appendChild(new Element[]{new StepElement(this.ensureUID(step)).getElement()});
    }

    private void setupByLocale() {
        this.setArrayProperty("monthNames", new DateFormatSymbols(this.getLocale()).getMonths());
        this.setArrayProperty("weekdayNames", new DateFormatSymbols(this.getLocale()).getWeekdays());
        GregorianCalendar cal = new GregorianCalendar(this.getLocale());
        this.getElement().setProperty("firstDayOfWeek", (double)cal.getFirstDayOfWeek());
    }

    private void setArrayProperty(String name, String[] array) {
        ArrayNode jsonArray = JacksonUtils.createArrayNode();
        for (int index = 0; index < array.length; ++index) {
            jsonArray.add(array[index]);
        }
        this.getElement().executeJs("this." + name + " = $0;", new Object[]{jsonArray});
    }

    LocalDateTime resetTimeToMin(LocalDateTime dateTime) {
        return GanttUtil.resetTimeToMin(dateTime, this.getResolution());
    }

    LocalDateTime resetTimeToMax(LocalDateTime dateTime, boolean exclusive) {
        return GanttUtil.resetTimeToMax(dateTime, this.getResolution(), exclusive);
    }

    public StepElement getStepElement(String uid) {
        return this.getStepElementOptional(uid).orElse(null);
    }

    public Optional<StepElement> getStepElementOptional(String uid) {
        return this.getFlatStepElements().filter(step -> Objects.equals(uid, step.getUid())).findFirst();
    }

    public Stream<StepElement> getStepElements() {
        return this.getChildren().filter(child -> child instanceof StepElement).map(StepElement.class::cast);
    }

    public Stream<Step> getSteps() {
        return this.getChildren().filter(child -> child instanceof StepElement).map(StepElement.class::cast).map(StepElement::getModel).map(Step.class::cast);
    }

    public List<Step> getStepsList() {
        return this.getSteps().collect(Collectors.toList());
    }

    public Stream<StepElement> getFlatStepElements() {
        Stream.Builder streamBuilder = Stream.builder();
        this.getStepElements().forEach(step -> {
            streamBuilder.add(step);
            step.getChildren().filter(child -> child instanceof StepElement).map(StepElement.class::cast).forEach(streamBuilder::add);
        });
        return streamBuilder.build();
    }

    public Stream<StepElement> getSubStepElements(String forStepUid) {
        StepElement stepEl = this.getStepElement(forStepUid);
        if (stepEl != null) {
            return stepEl.getChildren().filter(child -> child instanceof StepElement).map(StepElement.class::cast);
        }
        return Stream.empty();
    }

    public Stream<StepElement> getSubStepElements() {
        return this.getStepElements().flatMap(step -> step.getChildren().filter(child -> child instanceof StepElement)).map(StepElement.class::cast);
    }

    public Stream<SubStep> getSubSteps() {
        return this.getSubStepElements().map(StepElement::getModel).map(SubStep.class::cast);
    }

    public boolean contains(String targetUid) {
        return this.getFlatStepElements().anyMatch(step -> step.getUid().equals(targetUid));
    }

    public boolean contains(GanttStep targetStep) {
        return this.getFlatStepElements().anyMatch(step -> step.getUid().equals(targetStep.getUid()));
    }

    public boolean contains(Step targetStep) {
        return this.contains(this.getStepElements(), targetStep.getUid());
    }

    public boolean contains(SubStep targetSubStep) {
        return this.contains(this.getSubStepElements(), targetSubStep.getUid());
    }

    private boolean contains(Stream<StepElement> stream, String targetUid) {
        return stream.filter(child -> child instanceof StepElement).map(StepElement.class::cast).anyMatch(step -> step.getUid().equals(targetUid));
    }

    public int indexOf(Step step) {
        return this.indexOf(step.getUid());
    }

    public int indexOf(String stepUid) {
        GanttStep step = this.getAnyStep(stepUid);
        if (step.isSubstep()) {
            step = ((SubStep)step).getOwner();
        }
        List uidList = this.getStepElements().map(StepElement::getUid).collect(Collectors.toList());
        return uidList.indexOf(step.getUid());
    }

    public SubStep getSubStep(String uid) {
        return this.getSubStepElements().filter(step -> Objects.equals(uid, step.getUid())).findFirst().map(StepElement::getModel).map(SubStep.class::cast).orElse(null);
    }

    public Step getStep(String uid) {
        return this.getStepElements().filter(step -> Objects.equals(uid, step.getUid())).findFirst().map(StepElement::getModel).map(Step.class::cast).orElse(null);
    }

    public GanttStep getAnyStep(String uid) {
        return this.getFlatStepElements().filter(step -> Objects.equals(uid, step.getUid())).findFirst().map(StepElement::getModel).orElse(null);
    }

    public void updateSubStepsByMovedOwner(String stepUid) {
        Step step = this.getStep(stepUid);
        LocalDateTime previousStart = this.getSubStepElements(stepUid).map(StepElement::getModel).map(GanttStep::getStartDate).min(Comparator.naturalOrder()).orElse(step.getStartDate());
        Duration delta = Duration.between(previousStart, step.getStartDate());
        this.getSubStepElements(stepUid).forEach(substep -> {
            substep.getModel().setStartDate(substep.getModel().getStartDate().plus(delta));
            substep.getModel().setEndDate(substep.getModel().getEndDate().plus(delta));
            substep.refresh();
        });
    }

    public void refresh(String uid) {
        StepElement stepElement = this.getStepElement(uid);
        if (stepElement != null) {
            stepElement.refresh();
        }
    }

    protected <T extends GanttStep> T ensureUID(T step) {
        if (step == null) {
            return null;
        }
        if (step.getUid() == null || step.getUid().isEmpty()) {
            step.setUid(UUID.randomUUID().toString());
        }
        return step;
    }

    public void setWidth(String width) {
        this.getElement().getStyle().set("--gantt-element-width", Objects.requireNonNullElse(width, "auto"));
        this.getElement().callJsFunction("updateSize", new Object[0]);
    }

    public void setHeight(String height) {
        this.getElement().getStyle().set("--gantt-element-height", Objects.requireNonNullElse(height, "auto"));
        this.getElement().callJsFunction("updateSize", new Object[0]);
    }

    public Registration addGanttClickListener(ComponentEventListener<GanttClickEvent> listener) {
        return this.addListener(GanttClickEvent.class, listener);
    }

    public Registration addStepClickListener(ComponentEventListener<StepClickEvent> listener) {
        return this.addListener(StepClickEvent.class, listener);
    }

    public Registration addStepMoveListener(final ComponentEventListener<StepMoveEvent> listener) {
        this.moveListeners.add(listener);
        return new Registration(){

            public void remove() {
                Gantt.this.moveListeners.remove(listener);
            }
        };
    }

    private void fireMoveListeners(StepMoveEvent event) {
        this.moveListeners.forEach(listener -> listener.onComponentEvent((ComponentEvent)event));
    }

    public Registration addStepResizeListener(ComponentEventListener<StepResizeEvent> listener) {
        return this.addListener(StepResizeEvent.class, listener);
    }

    public Registration addDataChangeListener(ComponentEventListener<GanttDataChangeEvent> listener) {
        return this.addListener(GanttDataChangeEvent.class, listener);
    }

    public Grid<Step> buildCaptionGrid(String header) {
        Grid grid;
        this.removeCaptionGrid();
        this.captionGrid = grid = new Grid();
        grid.getStyle().set("--gantt-caption-grid-row-height", "30px");
        grid.addClassName("gantt-caption-grid");
        grid.addColumn((Renderer)LitRenderer.of((String)"<span>${item.caption}</span>").withProperty("caption", GanttStep::getCaption)).setHeader(header).setResizable(true);
        this.captionGridColumnResizeListener = grid.addColumnResizeListener((ComponentEventListener & Serializable)event -> {
            if (event.isFromClient()) {
                this.refreshForHorizontalScrollbar();
            }
        });
        grid.setItems((CallbackDataProvider.FetchCallback & Serializable)query -> this.getSteps().skip(query.getOffset()).limit(query.getLimit()));
        this.captionGridDataChangeListener = this.addDataChangeListener((ComponentEventListener<GanttDataChangeEvent>)(ComponentEventListener & Serializable)event -> {
            grid.getLazyDataView().refreshAll();
            this.refreshForHorizontalScrollbar();
        });
        this.getElement().executeJs("this.registerScrollElement($0.$.table)", new Object[]{grid});
        this.refreshForHorizontalScrollbar();
        return grid;
    }

    public TreeGrid<Step> buildCaptionTreeGrid(String header) {
        TreeGrid grid;
        this.removeCaptionGrid();
        this.captionGrid = grid = new TreeGrid();
        grid.getStyle().set("--gantt-caption-grid-row-height", "30px");
        grid.addClassName("gantt-caption-grid");
        ((Grid.Column)grid.addHierarchyColumn(GanttStep::getCaption).setHeader(header).setResizable(true)).setSortable(false);
        this.captionGridColumnResizeListener = grid.addColumnResizeListener((ComponentEventListener & Serializable)event -> {
            if (event.isFromClient()) {
                this.refreshForHorizontalScrollbar();
            }
        });
        TreeData treeData = new TreeData();
        treeData.addRootItems(this.getStepsList());
        TreeDataProvider dataProvider = new TreeDataProvider(treeData);
        grid.setDataProvider((HierarchicalDataProvider)dataProvider);
        grid.addExpandListener((ComponentEventListener & Serializable)event -> this.addChildStepRecursively((TreeGrid<Step>)grid, event.getItems(), new AtomicInteger(), false));
        grid.addCollapseListener((ComponentEventListener & Serializable)event -> this.removeChildStepRecursively((TreeGrid<Step>)grid, event.getItems()));
        this.captionGridDataChangeListener = this.addDataChangeListener((ComponentEventListener<GanttDataChangeEvent>)(ComponentEventListener & Serializable)event -> {
            switch (event.getDataEvent()) {
                case STEP_ADD: {
                    event.getSteps().forEach(step -> this.handleTreeDataAdd((TreeData<Step>)treeData, (Step)step));
                    break;
                }
                case STEP_REMOVE: {
                    event.getSteps().forEach(step -> {
                        this.removeChildStepRecursively(this.getCaptionTreeGrid(), (Step)step);
                        grid.getTreeData().removeItem(step);
                    });
                    break;
                }
                case STEP_MOVE: {
                    event.getSteps().forEach(step -> this.handleTreeDataMove((TreeData<Step>)grid.getTreeData(), (Step)step));
                    break;
                }
            }
            grid.getDataProvider().refreshAll();
            this.refreshForHorizontalScrollbar();
        });
        this.getElement().executeJs("this.registerScrollElement($0.$.table)", new Object[]{grid});
        this.refreshForHorizontalScrollbar();
        return grid;
    }

    protected void handleTreeDataAdd(TreeData<Step> treeData, Step step) {
        treeData.addRootItems((Object[])new Step[]{step});
        int flatSiblingIndex = this.indexOf(step) - 1;
        if (flatSiblingIndex >= 0) {
            Step flatSibling = this.getStepsList().get(flatSiblingIndex);
            if (this.getCaptionTreeGrid().isExpanded((Object)flatSibling)) {
                treeData.setParent((Object)step, (Object)flatSibling);
                treeData.moveAfterSibling((Object)step, null);
            } else {
                treeData.setParent((Object)step, (Object)((Step)treeData.getParent((Object)flatSibling)));
                treeData.moveAfterSibling((Object)step, (Object)flatSibling);
            }
        } else {
            treeData.moveAfterSibling((Object)step, null);
        }
    }

    protected void handleTreeDataMove(TreeData<Step> treeData, Step step) {
        boolean isSiblingStepExpanded;
        Step oldParent = (Step)treeData.getParent((Object)step);
        Step newParent = null;
        int index = this.indexOf(step);
        Step prevNewSibling = null;
        Step nextNewSibling = null;
        if (index > 0) {
            List<Step> oldFlatSubTree = this.getFlatSubTreeRecursively(treeData, step);
            List<Step> stepList = this.getStepsList();
            prevNewSibling = stepList.get(index - 1);
            Step step2 = nextNewSibling = stepList.size() > index + 1 ? this.getStepsList().get(index + 1) : null;
            if (!oldFlatSubTree.contains(prevNewSibling)) {
                if (Objects.equals(prevNewSibling, oldParent)) {
                    newParent = prevNewSibling;
                    prevNewSibling = null;
                } else if (prevNewSibling != null && nextNewSibling != null && Objects.equals(prevNewSibling, treeData.getParent((Object)nextNewSibling))) {
                    newParent = prevNewSibling;
                    prevNewSibling = null;
                } else {
                    newParent = (Step)treeData.getParent((Object)prevNewSibling);
                }
                treeData.setParent((Object)step, (Object)newParent);
                treeData.moveAfterSibling((Object)step, (Object)prevNewSibling);
            } else {
                prevNewSibling = null;
            }
        } else {
            treeData.setParent((Object)step, newParent);
            treeData.moveAfterSibling((Object)step, null);
        }
        boolean isStepExpanded = this.getCaptionTreeGrid().isExpanded((Object)step);
        boolean bl = isSiblingStepExpanded = prevNewSibling != null && this.getCaptionTreeGrid().isExpanded((Object)prevNewSibling);
        if (isStepExpanded) {
            this.removeChildStepRecursively(this.getCaptionTreeGrid(), step);
        }
        if (isSiblingStepExpanded) {
            this.removeChildStepRecursively(this.getCaptionTreeGrid(), prevNewSibling);
        }
        if (isStepExpanded) {
            this.expand(step);
        }
        if (isSiblingStepExpanded) {
            this.expand(prevNewSibling);
        }
        if (isStepExpanded) {
            this.reset();
        }
    }

    private void reset() {
        List<StepElement> allSteps = this.getStepElements().toList();
        List<StepElement> allSubSteps = this.getSubStepElements().toList();
        allSteps.forEach(s -> this.doRemoveStep((Step)s.getModel(), false));
        allSteps.forEach(s -> this.getElement().appendChild(new Element[]{s.getElement()}));
        allSubSteps.forEach(this::addSubStepElement);
    }

    public void expand(Step item) {
        this.expand(List.of(item));
    }

    public void expand(Step item, boolean expandWholeSubTree) {
        this.expand(List.of(item), expandWholeSubTree);
    }

    public void expand(Collection<Step> items) {
        this.expand(items, true);
    }

    public void expand(Collection<Step> items, boolean expandWholeSubTree) {
        if (this.getCaptionTreeGrid() == null) {
            return;
        }
        this.addChildStepRecursively(this.getCaptionTreeGrid(), items, new AtomicInteger(), expandWholeSubTree);
    }

    private void addChildStepRecursively(TreeGrid<Step> grid, Collection<Step> items, AtomicInteger index, boolean expandWholeSubTree) {
        items.forEach(item -> this.addChildStepRecursively(grid, (Step)item, index, expandWholeSubTree));
    }

    private void addChildStepRecursively(TreeGrid<Step> grid, Step item, AtomicInteger index, boolean expandWholeSubTree) {
        HierarchicalDataProvider dataProvider = grid.getDataProvider();
        if (!dataProvider.hasChildren((Object)item)) {
            return;
        }
        if (!expandWholeSubTree && !grid.isExpanded((Object)item)) {
            return;
        }
        if (index.get() == 0) {
            index.set(this.getStepsList().indexOf(item) + 1);
        }
        for (Step child : grid.getTreeData().getChildren((Object)item)) {
            this.addStep(index.get(), child, false);
            index.incrementAndGet();
            this.addChildStepRecursively(grid, child, index, expandWholeSubTree);
        }
    }

    private List<Step> getFlatSubTreeRecursively(TreeData<Step> treeData, Step step) {
        ArrayList<Step> steps = new ArrayList<Step>();
        if (treeData.contains((Object)step)) {
            for (Step child : treeData.getChildren((Object)step)) {
                steps.add(child);
                steps.addAll(this.getFlatSubTreeRecursively(treeData, child));
            }
        }
        return steps;
    }

    private void removeChildStepRecursively(TreeGrid<Step> grid, Collection<Step> items) {
        items.stream().forEach(item -> this.removeChildStepRecursively(grid, (Step)item));
    }

    private void removeChildStepRecursively(TreeGrid<Step> grid, Step step) {
        HierarchicalDataProvider dataProvider = grid.getDataProvider();
        if (dataProvider.hasChildren((Object)step)) {
            for (Step child : grid.getTreeData().getChildren((Object)step)) {
                this.doRemoveStep(child, false);
                this.removeChildStepRecursively(grid, child);
            }
        }
    }

    public void removeCaptionGrid() {
        if (this.captionGrid != null) {
            this.captionGridDataChangeListener.remove();
            this.captionGridColumnResizeListener.remove();
            this.getElement().executeJs("this.registerScrollElement(null)", new Object[0]);
            this.getElement().executeJs("this._container.style.overflowX = 'auto';", new Object[0]);
            this.captionGrid = null;
        }
    }

    public Grid<Step> getCaptionGrid() {
        return this.captionGrid;
    }

    public TreeGrid<Step> getCaptionTreeGrid() {
        return this.captionGrid instanceof TreeGrid ? (TreeGrid)this.captionGrid : null;
    }

    private void refreshForHorizontalScrollbar() {
        if (this.captionGrid == null) {
            return;
        }
        this.getElement().executeJs("let self = this;\nthis.updateComplete.then(() => {\n\t\t$0.style.setProperty('--gantt-caption-grid-header-height', self._timeline.clientHeight+'px');\n\t\t$0.$.table.style.width='calc(100% + '+self.scrollbarWidth+'px';\n\t\tconst left = $0.$.table.scrollLeft > 0;\n\t\tconst right = $0.$.table.scrollLeft < $0.$.table.scrollWidth - $0.$.table.clientWidth;\n\t\tconst gridOverflowX = left || right;\n\t\tthis._container.style.overflowX = (gridOverflowX) ? 'scroll' : 'auto';\n\t\tif(self.isContentOverflowingHorizontally() && !gridOverflowX) {\n\t\t\t$0.$.scroller.style.height = 'calc(100% - ' + self.scrollbarWidth + 'px)';\n\t\t\t$0.$.scroller.style.minHeight = $0.$.scroller.style.height;\n\t\t} else {\n\t\t\t$0.$.scroller.style.removeProperty('height');\n\t\t\t$0.$.scroller.style.removeProperty('min-height');\n\t\t}\n\t})\n", new Object[]{this.captionGrid});
    }

    private void fireDataChangeEvent(GanttDataChangeEvent.DataEvent eventType, Stream<Step> steps) {
        this.fireEvent(new GanttDataChangeEvent(this, eventType, steps));
    }
}

