/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.tatu;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.shared.HasTooltip;

@JsModule(value="./circular-progress-bar.ts")
@Tag(value="circular-progress-bar")
public class CircularProgressBar
extends Component
implements HasSize,
HasTooltip {
    public CircularProgressBar() {
        this.setBorder(false);
    }

    public void setScale(double scale) {
        this.getElement().setProperty("scale", scale);
    }

    public void setPercent(double percent) {
        if (percent < 0.0) {
            throw new IllegalArgumentException("percent can't be negative");
        }
        if (percent > 1.0) {
            throw new IllegalArgumentException("percent can't be over 1.0");
        }
        this.getElement().setProperty("percent", percent);
    }

    public void setCaption(String caption) {
        this.getElement().setProperty("label", caption);
    }

    public void setColor(String color) {
        this.getElement().getStyle().set("--circle-color", color);
    }

    public void setAnimation(boolean animation) {
        this.getElement().setProperty("animation", animation);
    }

    public void setDelay(int delay) {
        this.getElement().setProperty("delay", (double)delay);
    }

    public void setBorder(boolean border) {
        if (border) {
            this.getElement().removeAttribute("noborder");
        } else {
            this.getElement().setAttribute("noborder", true);
        }
    }
}

