/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.stefan.gridscroller;

import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import java.util.Objects;
import tools.jackson.databind.node.ArrayNode;

public class GridScroller {
    private final Grid<?> grid;

    public GridScroller(Grid<?> grid) {
        this.grid = Objects.requireNonNull(grid, "Grid is required");
    }

    public static void scrollTop(Grid<?> grid, Double value) {
        GridScroller.modifyScrollValue(grid, value, "scrollTop");
    }

    public static void scrollLeft(Grid<?> grid, Double value) {
        GridScroller.modifyScrollValue(grid, value, "scrollLeft");
    }

    private static PendingJavaScriptResult modifyScrollValue(Grid<?> grid, Double value, String scrollProperty) {
        return grid.getElement().executeJs("this.$.table[$1] = $0;", new Object[]{value != null ? value : 0.0, scrollProperty});
    }

    public static void scroll(Grid<?> grid, Double left, Double top) {
        grid.getElement().executeJs("this.$.table.scrollLeft = $0; this.$.table.scrollTop = $1;", new Object[]{left != null ? left : 0.0, top != null ? top : 0.0});
    }

    public static void scroll(Grid<?> grid, ScrollPosition scrollPosition) {
        if (scrollPosition == null) {
            GridScroller.scroll(grid, null, null);
        } else {
            GridScroller.scroll(grid, scrollPosition.getLeft(), scrollPosition.getTop());
        }
    }

    public void scroll(Double left, Double top) {
        GridScroller.scroll(this.getGrid(), left, top);
    }

    public void scroll(ScrollPosition scrollPosition) {
        GridScroller.scroll(this.getGrid(), scrollPosition);
    }

    public static void readScrollPositions(Grid<?> grid, SerializableConsumer<ScrollPosition> leftTopConsumer) {
        grid.getElement().executeJs("return [this.$.table.scrollLeft, this.$.table.scrollTop]", new Object[0]).then((SerializableConsumer & Serializable)jsonValue -> {
            if (!(jsonValue instanceof ArrayNode)) {
                throw new IllegalStateException("Could not read from client, result is not a json array, but " + jsonValue.asString());
            }
            ArrayNode array = (ArrayNode)jsonValue;
            double left = array.get(0).asDouble();
            double top = array.get(1).asDouble();
            leftTopConsumer.accept((Object)new ScrollPosition(left, top));
        });
    }

    public void scrollTop(Double value) {
        GridScroller.scrollTop(this.getGrid(), value);
    }

    public void scrollLeft(Double value) {
        GridScroller.scrollLeft(this.getGrid(), value);
    }

    public void readScrollPositions(SerializableConsumer<ScrollPosition> leftTopConsumer) {
        GridScroller.readScrollPositions(this.getGrid(), leftTopConsumer);
    }

    public Grid<?> getGrid() {
        return this.grid;
    }

    public static class ScrollPosition {
        private final double left;
        private final double top;

        public ScrollPosition(double left, double top) {
            this.left = left;
            this.top = top;
        }

        public double getLeft() {
            return this.left;
        }

        public double getTop() {
            return this.top;
        }
    }
}

