/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addon.stefan.clipboard;

import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

@JsModule(value="./clipboard/clipboard.js")
public class ClientsideClipboard {
    private static final String CALLER = "window.Vaadin.Flow._clipboard";
    private static final String METHOD_WRITE = "return window.Vaadin.Flow._clipboard.writeToClipboard($0)";
    private static final String METHOD_READ = "return window.Vaadin.Flow._clipboard.readFromClipboard()";

    public static void writeToClipboard(String valueToWrite) {
        ClientsideClipboard.writeToClipboard(valueToWrite, UI.getCurrent());
    }

    public static void writeToClipboard(String valueToWrite, SerializableConsumer<Boolean> onWritingDone) {
        ClientsideClipboard.writeToClipboard(valueToWrite, UI.getCurrent(), onWritingDone);
    }

    public static void writeToClipboard(String valueToWrite, UI ui) {
        ClientsideClipboard.writeToClipboard(valueToWrite, ui, (SerializableConsumer<Boolean>)(SerializableConsumer & Serializable)result -> {});
    }

    public static void writeToClipboard(String valueToWrite, UI ui, SerializableConsumer<Boolean> onWritingDone) {
        ClientsideClipboard.execute((HasElement)ui, METHOD_WRITE, new Serializable[]{valueToWrite}).then(Boolean.class, onWritingDone);
    }

    public static void readFromClipboard(Consumer<String> valueHasBeenReadCallback) {
        ClientsideClipboard.readFromClipboard(valueHasBeenReadCallback, UI.getCurrent());
    }

    public static void readFromClipboard(Consumer<String> valueHasBeenReadCallback, UI ui) {
        ClientsideClipboard.readFromClipboard(ui).handle((s, throwable) -> {
            if (throwable != null) {
                throw new RuntimeException((Throwable)throwable);
            }
            valueHasBeenReadCallback.accept((String)s);
            return null;
        });
    }

    public static CompletableFuture<String> readFromClipboard() {
        return ClientsideClipboard.execute((HasElement)UI.getCurrent(), METHOD_READ, new Serializable[0]).toCompletableFuture(String.class);
    }

    public static CompletableFuture<String> readFromClipboard(UI ui) {
        return ClientsideClipboard.execute((HasElement)ui, METHOD_READ, new Serializable[0]).toCompletableFuture(String.class);
    }

    private static PendingJavaScriptResult execute(HasElement executor, String script, Serializable ... parameters) {
        return executor.getElement().executeJs(script, parameters);
    }
}

