/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.helper;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.littemplate.LitTemplate;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import tools.jackson.databind.JsonNode;

public abstract class LitComponent
extends LitTemplate {
    private final List<JSFunction> functions = new ArrayList<JSFunction>();
    private volatile boolean ready = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ClientCallable
    private void ready() {
        List<JSFunction> list = this.functions;
        synchronized (list) {
            while (!this.functions.isEmpty()) {
                JSFunction function = this.functions.removeFirst();
                JSResult r = (JSResult)function.result;
                PendingJavaScriptResult pr = this.exec(function.function, function.parameters);
                pr.then(r.successConsumer, r.failureConsumer);
                function.result = pr;
            }
            this.ready = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized PendingJavaScriptResult executeJS(String function, Object ... parameters) {
        if (this.ready) {
            return this.exec(function, parameters);
        }
        List<JSFunction> list = this.functions;
        synchronized (list) {
            if (this.ready) {
                return this.exec(function, parameters);
            }
            JSFunction jsFunction = new JSFunction(function, parameters);
            this.functions.add(jsFunction);
            jsFunction.result = new JSResult(jsFunction);
            return jsFunction.result;
        }
    }

    private PendingJavaScriptResult exec(String function, Object ... parameters) {
        return this.getElement().callJsFunction(function, parameters);
    }

    protected void onDetach(DetachEvent detachEvent) {
        this.ready = false;
        super.onDetach(detachEvent);
    }

    private static class JSFunction {
        private final String function;
        private final Object[] parameters;
        private PendingJavaScriptResult result;

        private JSFunction(String function, Object ... parameters) {
            this.function = function;
            this.parameters = parameters;
        }
    }

    private class JSResult
    implements PendingJavaScriptResult {
        private final JSFunction function;
        private SerializableConsumer<JsonNode> successConsumer = (SerializableConsumer & Serializable)j -> {};
        private SerializableConsumer<String> failureConsumer = (SerializableConsumer & Serializable)s -> {};

        private JSResult(JSFunction function) {
            this.function = function;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancelExecution() {
            if (LitComponent.this.ready) {
                return this.function.result.cancelExecution();
            }
            List<JSFunction> list = LitComponent.this.functions;
            synchronized (list) {
                if (LitComponent.this.ready) {
                    return this.function.result.cancelExecution();
                }
                return LitComponent.this.functions.removeIf(r -> r.result == this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isSentToBrowser() {
            if (LitComponent.this.ready) {
                return this.function.result.isSentToBrowser();
            }
            List<JSFunction> list = LitComponent.this.functions;
            synchronized (list) {
                return LitComponent.this.ready && this.function.result.isSentToBrowser();
            }
        }

        public void then(SerializableConsumer<JsonNode> successConsumer, SerializableConsumer<String> failureConsumer) {
            if (successConsumer != null) {
                this.successConsumer = successConsumer;
            }
            if (failureConsumer != null) {
                this.failureConsumer = failureConsumer;
            }
        }
    }
}

