/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin.util;

import com.storedobject.vaadin.Application;
import com.storedobject.vaadin.CustomTextField;
import com.vaadin.flow.component.textfield.TextField;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public abstract class NumericField<T extends Number>
extends CustomTextField<T> {
    protected boolean grouping;
    protected boolean allowNegative;
    protected int width;

    protected NumericField(T defaultValue) {
        super(defaultValue);
        ((TextField)this.getField()).setAutoselect(true);
    }

    public final boolean isGrouping() {
        return this.grouping;
    }

    public void setGrouping(boolean grouping) {
        this.grouping = grouping;
    }

    public final boolean getAllowNegative() {
        return this.allowNegative;
    }

    public void setAllowNegative(boolean allowNegative) {
        this.allowNegative = allowNegative;
    }

    public void setValue(T value) {
        if (value == null) {
            value = (Number)this.getEmptyValue();
        }
        super.setValue(value);
    }

    public final int getLength() {
        return this.width;
    }

    public int getDecimals() {
        return 0;
    }

    @Override
    protected String format(T value) {
        if (value == null) {
            value = (Number)this.getEmptyValue();
        }
        DecimalFormat format = "CN".equals(this.getCountry()) ? new DecimalFormat("##,##,##,#0.00") : (DecimalFormat)DecimalFormat.getNumberInstance();
        format.setMaximumIntegerDigits(30);
        format.setRoundingMode(RoundingMode.HALF_UP);
        int decimals = this.getDecimals();
        if (decimals < 0) {
            format.setMinimumFractionDigits(decimals < -1 ? -decimals : 14);
            format.setMaximumFractionDigits(decimals < -1 ? -decimals : 14);
        } else {
            format.setMinimumFractionDigits(decimals);
            format.setMaximumFractionDigits(decimals);
        }
        String s = format.format(value);
        if (this.grouping) {
            if ("IN".equals(this.getCountry())) {
                return NumericField.indianStyle(s);
            }
            return s;
        }
        return s.replace(",", "");
    }

    private static String indianStyle(String v) {
        StringBuilder s;
        int i = (v = v.replace(",", "")).indexOf(46);
        if (i >= 0) {
            s = new StringBuilder(v.substring(i));
            v = v.substring(0, i);
        } else {
            s = new StringBuilder();
        }
        if (v.length() <= 3) {
            return v + String.valueOf(s);
        }
        s.insert(0, v.substring(v.length() - 3));
        v = v.substring(0, v.length() - 3);
        while (v.length() > 0) {
            s.insert(0, ",");
            if (v.length() <= 2) {
                s.insert(0, v);
                break;
            }
            s.insert(0, v.substring(v.length() - 2));
            v = v.substring(0, v.length() - 2);
        }
        return s.toString();
    }

    protected abstract int getDefaultLength();

    public final void setLength(int width) {
        int decimals;
        if (width < 1) {
            width = 18;
        }
        int min = 1;
        if (this.allowNegative) {
            ++min;
        }
        if ((decimals = this.getDecimals()) > 0) {
            min += decimals + 1;
        }
        if (width < min) {
            width = min;
        }
        this.width = width;
        this.getField().setMaxLength(width);
    }

    protected String getCountry() {
        Application a = Application.get();
        return a == null ? "US" : a.getCountry();
    }
}

