/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin.util;

import com.storedobject.vaadin.MediaCapture;
import com.vaadin.flow.server.StreamVariable;
import java.io.OutputStream;

public class MediaStreamVariable
implements StreamVariable {
    private String mime;
    private final MediaCapture.DataReceiver receiver;
    private OutputStream out;
    private boolean aborted = false;

    public MediaStreamVariable(MediaCapture.DataReceiver receiver) {
        this.receiver = receiver;
    }

    public OutputStream getOutputStream() {
        if (this.out == null) {
            this.out = this.receiver.getOutputStream(this.mime);
        } else if (!this.aborted) {
            this.aborted = true;
            this.receiver.aborted();
        }
        return this.out;
    }

    public boolean isInterrupted() {
        return this.aborted;
    }

    public boolean listenProgress() {
        return false;
    }

    public void onProgress(StreamVariable.StreamingProgressEvent event) {
    }

    public void streamingFailed(StreamVariable.StreamingErrorEvent event) {
        if (!this.aborted) {
            this.aborted = true;
            this.receiver.aborted();
        }
    }

    public void streamingFinished(StreamVariable.StreamingEndEvent event) {
        if (!this.aborted) {
            this.receiver.finished();
        }
    }

    public void streamingStarted(StreamVariable.StreamingStartEvent event) {
        this.mime = event.getMimeType();
    }

    public String getMime() {
        return this.mime;
    }
}

