/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin.util;

import com.storedobject.vaadin.util.PatternField;
import org.vaadin.textfieldformatter.CustomStringBlockFormatter;

public class MACAddressTextField
extends PatternField {
    private static final CustomStringBlockFormatter pattern = new CustomStringBlockFormatter(new int[]{2, 2, 2, 2, 2, 2}, new String[]{":", ":", ":", ":", ":", ":"}, CustomStringBlockFormatter.ForceCase.LOWER, "", false);
    private static final String EMPTY = "00:00:00:00:00:00";

    public MACAddressTextField() {
        super(null, 17, pattern);
    }

    public String getEmptyValue() {
        return EMPTY;
    }

    public boolean isInvalid() {
        String[] blocks;
        if (super.isInvalid()) {
            return true;
        }
        for (String b : blocks = this.getValue().split(":")) {
            try {
                int v = Integer.parseInt(b, 16);
                if (v >= 0 && v <= 255) continue;
                this.setInvalid(true);
                return true;
            }
            catch (Throwable notNumeric) {
                this.setInvalid(true);
                return true;
            }
        }
        return false;
    }

    public static byte[] getAddress(String address) {
        try {
            String b;
            int v;
            String[] blocks = address.split(":");
            if (blocks.length != 6) {
                return MACAddressTextField.getAddress(EMPTY);
            }
            byte[] bytes = new byte[blocks.length];
            int i = 0;
            String[] stringArray = blocks;
            int n = stringArray.length;
            for (int j = 0; j < n && (v = Integer.parseInt(b = stringArray[j], 16)) >= 0 && v <= 255; ++j) {
                bytes[i++] = (byte)(v & 0xFF);
            }
            return bytes;
        }
        catch (Throwable throwable) {
            return MACAddressTextField.getAddress(EMPTY);
        }
    }

    public static String getAddress(byte[] address) {
        if (address == null || address.length != 6) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        for (byte b : address) {
            int i = b & 0xFF;
            if (s.length() > 0) {
                s.append(':');
            }
            s.append(String.format("%02X", i));
        }
        return s.toString();
    }
}

