/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin.util;

import com.storedobject.vaadin.util.PatternField;
import java.net.Inet4Address;
import java.net.InetAddress;
import org.vaadin.textfieldformatter.CustomStringBlockFormatter;

public class IPAddressTextField
extends PatternField {
    private static final CustomStringBlockFormatter pattern = new CustomStringBlockFormatter(new int[]{3, 3, 3, 3}, new String[]{".", ".", ".", "."}, CustomStringBlockFormatter.ForceCase.NONE, "", true);
    private static final String EMPTY = "000.000.000.000";

    public IPAddressTextField() {
        super(null, 15, pattern);
    }

    public String getEmptyValue() {
        return EMPTY;
    }

    public boolean isInvalid() {
        String[] blocks;
        if (super.isInvalid()) {
            return true;
        }
        for (String b : blocks = this.getValue().split("\\.")) {
            try {
                int v = Integer.parseInt(b);
                if (v >= 0 && v <= 255) continue;
                this.setInvalid(true);
                return true;
            }
            catch (Throwable notNumeric) {
                this.setInvalid(true);
                return true;
            }
        }
        return false;
    }

    public static Inet4Address getAddress(String a) {
        try {
            return (Inet4Address)InetAddress.getByName(a);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String getAddress(Inet4Address a) {
        return a == null ? EMPTY : IPAddressTextField.pad(a.getHostAddress());
    }

    private static String pad(String a) {
        String[] blocks;
        StringBuilder s = new StringBuilder();
        for (String block : blocks = a.split("\\.")) {
            if (s.length() > 0) {
                s.append('.');
            }
            s.append(String.format("%03d", Integer.parseInt(block)));
        }
        return s.toString();
    }
}

