/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin.util;

import com.storedobject.vaadin.util.PatternField;
import java.net.Inet6Address;
import java.net.InetAddress;
import org.vaadin.textfieldformatter.CustomStringBlockFormatter;

public class IP6AddressTextField
extends PatternField {
    private static final CustomStringBlockFormatter pattern = new CustomStringBlockFormatter(new int[]{4, 4, 4, 4, 4, 4, 4, 4}, new String[]{":", ":", ":", ":", ":", ":", ":", ":"}, CustomStringBlockFormatter.ForceCase.LOWER, "", false);
    private static final String EMPTY = "0000:0000:0000:0000:0000:0000:0000:0000";

    public IP6AddressTextField() {
        super(null, 39, pattern);
        this.setMinWidth("22em");
    }

    public String getEmptyValue() {
        return EMPTY;
    }

    public boolean isInvalid() {
        String[] blocks;
        if (super.isInvalid()) {
            return true;
        }
        for (String b : blocks = this.getValue().split(":")) {
            try {
                int v = Integer.parseInt(b, 16);
                if (v >= 0 && v <= 65535) continue;
                this.setInvalid(true);
                return true;
            }
            catch (Throwable notNumeric) {
                this.setInvalid(true);
                return true;
            }
        }
        return false;
    }

    public static Inet6Address getAddress(String a) {
        try {
            return (Inet6Address)InetAddress.getByName(a);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String getAddress(Inet6Address a) {
        return a == null ? EMPTY : IP6AddressTextField.pad(a.getHostAddress());
    }

    private static String pad(String a) {
        String[] blocks;
        StringBuilder s = new StringBuilder();
        for (String block : blocks = a.split(":")) {
            if (s.length() > 0) {
                s.append(':');
            }
            s.append(String.format("%04X", Integer.parseInt(block, 16)));
        }
        return s.toString();
    }
}

