/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin.util;

import com.storedobject.vaadin.EnhancedClickEvent;
import com.storedobject.vaadin.util.ClickListeners;
import com.storedobject.vaadin.util.ClickNotifier;
import com.storedobject.vaadin.util.InternalElement;
import com.storedobject.vaadin.util.Listeners;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import java.util.EventListener;
import java.util.EventObject;

public class ElementClick
implements ClickNotifier {
    private final Component component;
    private final Listeners listeners = new ClickListeners();

    public ElementClick(Component component) {
        this(component, null);
    }

    public ElementClick(Component component, Element element) {
        this.component = component;
        if (element == null) {
            element = component instanceof InternalElement ? ((InternalElement)component).getInternalElement() : component.getElement();
        }
        element.addEventListener("click", this::handleClick).addEventData("event.screenX").addEventData("event.screenY").addEventData("event.clientX").addEventData("event.clientY").addEventData("event.offsetX").addEventData("event.offsetY").addEventData("event.detail").addEventData("event.button").addEventData("event.ctrlKey").addEventData("event.shiftKey").addEventData("event.altKey").addEventData("event.metaKey");
    }

    private void handleClick(DomEvent event) {
        JsonObject e = event.getEventData();
        EnhancedClickEvent ce = new EnhancedClickEvent(this.component, true, (int)e.getNumber("event.screenX"), (int)e.getNumber("event.screenY"), (int)e.getNumber("event.clientX"), (int)e.getNumber("event.clientY"), (int)e.getNumber("event.offsetX"), (int)e.getNumber("event.offsetY"), (int)e.getNumber("event.detail"), (int)e.getNumber("event.button"), e.getBoolean("event.ctrlKey"), e.getBoolean("event.shiftKey"), e.getBoolean("event.altKey"), e.getBoolean("event.metaKey"));
        this.listeners.fire((EventObject)((Object)ce));
    }

    public Registration addClickListener(ComponentEventListener<ClickEvent<Component>> listener) {
        return this.listeners.add((EventListener)listener);
    }

    @Override
    public void removeClickListener(ComponentEventListener<ClickEvent<Component>> listener) {
        this.listeners.remove((EventListener)listener);
    }
}

