/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin.util;

import com.storedobject.helper.ID;
import com.storedobject.vaadin.AbstractForm;
import com.storedobject.vaadin.Alert;
import com.storedobject.vaadin.Application;
import com.storedobject.vaadin.RequiredField;
import com.storedobject.vaadin.ValueRequired;
import com.storedobject.vaadin.util.FieldValueHandler;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

public class Data<T>
extends HashMap<String, Object> {
    private static final String FIELD_CANT_BE_EMPTY = "Field can't be empty!";
    private static final ValidationResult OK = ValidationResult.ok();
    private FieldValueHandler valueHandler;
    private final Map<String, HasValue<?, ?>> fields = new HashMap();
    private final Map<HasValue<?, ?>, String> fieldNames = new HashMap();
    private final Map<HasValue<?, ?>, DataValidators<T, ?>> validators = new HashMap();
    private final Map<HasValue<?, ?>, Binder.Binding<T, ?>> bindings = new HashMap();
    private Map<HasValue<?, ?>, List<Registration>> connections;
    private final Binder<T> binder;
    private boolean readOnly;
    private final AbstractForm<T> form;
    private Required requiredCache;
    private boolean extraErrors = false;
    private Alert errorText;

    public Data(AbstractForm<T> form) {
        this.form = form;
        this.binder = new Binder();
        this.binder.setStatusLabel((HasText)this.errorText());
    }

    private Alert errorText() {
        if (this.errorText == null) {
            Application a = Application.get();
            this.errorText = a == null ? new Alert(null, NotificationVariant.LUMO_PRIMARY) : a.getCommonAlert();
        }
        return this.errorText;
    }

    public Binder<T> getBinder() {
        return this.binder;
    }

    public void setErrorDisplay(HasText display) {
        this.binder.setStatusLabel((HasText)(display == null ? this.errorText() : display));
    }

    public HasText getErrorDisplay() {
        return this.binder.getStatusLabel().orElse(this.errorText());
    }

    public void setExtraErrors() {
        this.extraErrors = true;
    }

    public void setFieldValueHandler(FieldValueHandler valueHandler) {
        this.valueHandler = valueHandler;
    }

    public FieldValueHandler getFieldValueHandler() {
        return this.valueHandler;
    }

    public String addField(HasValue<?, ?> field) {
        return this.addField(null, field);
    }

    public String addField(String fieldName, HasValue<?, ?> field) {
        Binder.Binding binding;
        if (field == null) {
            return null;
        }
        if (fieldName == null || ((String)fieldName).isEmpty()) {
            fieldName = "_" + ID.newID();
        }
        if (this.fields.containsKey(fieldName)) {
            throw new RuntimeException("There is already a field with Id = " + (String)fieldName);
        }
        this.fields.put((String)fieldName, field);
        this.fieldNames.put(field, (String)fieldName);
        DataValidators<T, ?> validator = this.validator(field);
        Object name = fieldName;
        HasValue<?, ?> f = field;
        this.binder.withValidator(validator);
        if (this.valueHandler.isBasic() || !this.valueHandler.canHandle((String)name)) {
            this.setValue((String)fieldName, field.getValue());
            binding = this.binder.bind(f, arg_0 -> this.lambda$addField$6d863fc3$1((String)name, arg_0), (arg_0, arg_1) -> this.lambda$addField$ccbb81d0$1((String)name, arg_0, arg_1));
        } else {
            binding = this.valueHandler.canSet((String)name) ? this.binder.bind(f, arg_0 -> this.lambda$addField$6d863fc3$2((String)name, arg_0), (arg_0, arg_1) -> this.lambda$addField$ccbb81d0$2((String)name, arg_0, arg_1)) : this.binder.bind(f, arg_0 -> this.lambda$addField$6d863fc3$3((String)name, arg_0), null);
        }
        this.bindings.put(field, binding);
        if (field instanceof ValueRequired && ((ValueRequired)field).isRequired() && this.valueHandler.canSet((String)fieldName)) {
            this.setRequired(field, true, null);
        }
        return fieldName;
    }

    public boolean connect(Collection<HasValue<?, ?>> fields) {
        ArrayList fieldList = new ArrayList(fields);
        if (fieldList.size() <= 1) {
            return false;
        }
        if (this.connections == null) {
            this.connections = new HashMap();
            this.binder.setBean(this.form.getObject());
        }
        for (HasValue hasValue : fieldList) {
            List registrations = this.connections.computeIfAbsent(hasValue, k -> new ArrayList());
            registrations.add(hasValue.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                if (e.isFromClient()) {
                    this.updateConnections(e.getHasValue(), fieldList);
                }
            }));
        }
        return true;
    }

    private void updateConnections(HasValue<?, ?> source, List<HasValue<?, ?>> connections) {
        connections.forEach((? super T f) -> {
            if (f != source) {
                Binder.Binding<T, ?> binding = this.bindings.get(f);
                f.setValue(binding.getGetter().apply((Object)this));
            }
        });
    }

    private <F> DataValidators<T, F> validator(HasValue<?, F> field) {
        DataValidators<Object, Object> dv = this.validators.get(field);
        if (dv == null) {
            dv = new DataValidators(this.binder, field, this.errorText());
            this.validators.put(field, dv);
        }
        return dv;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        if (readOnly) {
            this.fields.forEach((key, value) -> {
                value.setReadOnly(true);
                this.setVisible((String)key, (HasValue<?, ?>)value);
            });
            return;
        }
        this.fields.forEach((key, value) -> {
            boolean ro = false;
            if (this.valueHandler.canHandle((String)key)) {
                boolean bl = ro = !this.valueHandler.canSet((String)key);
            }
            if (!ro) {
                boolean bl = ro = !this.valueHandler.isEditable((HasValue<?, ?>)value);
            }
            if (!ro) {
                ro = !this.valueHandler.isEditable((String)key);
            }
            value.setReadOnly(ro);
        });
    }

    private void setVisible(String fieldName, HasValue<?, ?> field) {
        if (!(field instanceof Component)) {
            return;
        }
        Component c = (Component)field;
        boolean v = this.valueHandler.isVisible(field);
        if (v) {
            v = this.valueHandler.isVisible(fieldName);
        }
        c.setVisible(v);
    }

    private Object getValue(String fieldName) {
        return this.get(fieldName);
    }

    private void setValue(String fieldName, Object value) {
        this.put(fieldName, value);
    }

    public HasValue<?, ?> removeField(String fieldName) {
        List<Registration> registrations;
        if (fieldName == null || fieldName.isEmpty()) {
            return null;
        }
        HasValue<?, ?> field = this.fields.remove(fieldName);
        if (field == null) {
            return null;
        }
        this.binder.removeBinding(field);
        this.bindings.remove(field);
        this.fieldNames.remove(field);
        this.validators.remove(field);
        if (this.connections != null && (registrations = this.connections.get(field)) != null) {
            registrations.forEach(Registration::remove);
            this.connections.remove(field);
        }
        this.remove(fieldName);
        return field;
    }

    public String getName(HasValue<?, ?> field) {
        return this.fieldNames.get(field);
    }

    public HasValue<?, ?> getField(String fieldName) {
        return this.fields.get(fieldName);
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public Stream<String> getFieldNames() {
        return this.fields.keySet().stream();
    }

    public Stream<HasValue<?, ?>> getFields() {
        return this.fieldNames.keySet().stream();
    }

    public void loadValues() {
        this.binder.readBean(this.form.getObject());
        this.setReadOnly(!this.readOnly);
        this.setReadOnly(!this.readOnly);
    }

    public boolean saveValues() {
        this.binder.getStatusLabel().ifPresent(errDisplay -> errDisplay.setText(""));
        for (HasValue<?, ?> field : this.fields.values()) {
            HasValidation hv;
            Component c;
            if (field.isReadOnly() || field instanceof Component && (!(c = (Component)field).isVisible() || !c.getElement().isEnabled())) continue;
            if (field.isRequiredIndicatorVisible() && field.isEmpty()) {
                this.showErr(field, FIELD_CANT_BE_EMPTY);
                return false;
            }
            if (!(field instanceof HasValidation) || !(hv = (HasValidation)field).isInvalid()) continue;
            this.showErr(field);
            return false;
        }
        this.extraErrors = false;
        if (!this.binder.writeBeanIfValid(this.form.getObject())) {
            return false;
        }
        if (!this.valueHandler.isBasic()) {
            this.fields.forEach((key, value) -> {
                if (this.valueHandler.canHandle((String)key) && !this.valueHandler.canSet((String)key)) {
                    HasValue field = value;
                    field.setValue(this.valueHandler.getValue((String)key));
                }
            });
        }
        if (this.extraErrors) {
            return false;
        }
        this.setReadOnly(!this.readOnly);
        this.setReadOnly(!this.readOnly);
        return true;
    }

    private void showErr(HasValue<?, ?> field) {
        this.showErr(field, null);
    }

    private void showErr(HasValue<?, ?> field, String m) {
        HasText hasText = this.binder.getStatusLabel().orElse(null);
        if (hasText == null) {
            return;
        }
        if (m == null && field instanceof HasValidation) {
            HasValidation hv = (HasValidation)field;
            m = hv.getErrorMessage();
        }
        m = this.errMessage(field, m == null ? "Not valid" : m);
        hasText.setText(m);
    }

    public void clearErrors() {
        this.fields.values().forEach(AbstractForm::clearError);
        if (this.errorText().equals(this.binder.getStatusLabel().orElse(null))) {
            this.errorText().close();
        }
    }

    public void clearFields() {
        this.fields.values().forEach(HasValue::clear);
    }

    public <F> void addValidator(HasValue<?, F> field, Function<F, Boolean> validator, String errorMessage) {
        if (field == null) {
            throw new RuntimeException(FIELD_CANT_BE_EMPTY);
        }
        this.validator(field).add(new DataValidator(this, validator, errorMessage));
    }

    public <F> void setRequired(HasValue<?, F> field, boolean required, String errorMessage) {
        Validator v;
        if (field == null) {
            throw new RuntimeException(FIELD_CANT_BE_EMPTY);
        }
        String fieldName = this.getName(field);
        if (fieldName != null && !this.valueHandler.canSet(fieldName)) {
            return;
        }
        if (field instanceof RequiredField) {
            ((RequiredField)field).setRequired(required);
        }
        field.setRequiredIndicatorVisible(required);
        DataValidators<T, F> dv = this.validator(field);
        if (!required) {
            if (dv.isEmpty()) {
                return;
            }
            if (dv.get(0) instanceof Required) {
                dv.remove(0);
            }
            return;
        }
        if (!dv.isEmpty() && (v = (Validator)dv.get(0)) instanceof Required) {
            if (errorMessage == null || errorMessage.isEmpty() ? ((Required)v).errorMessage == null : errorMessage.equals(((Required)v).errorMessage)) {
                return;
            }
            dv.remove(0);
        }
        dv.add(0, errorMessage == null || errorMessage.isEmpty() ? this.requiredCache() : new Required(this, errorMessage));
    }

    private Required requiredCache() {
        if (this.requiredCache == null) {
            this.requiredCache = new Required(this, null);
        }
        return this.requiredCache;
    }

    public static String getLabel(HasValue<?, ?> field) {
        try {
            return (String)field.getClass().getMethod("getLabel", new Class[0]).invoke(field, new Object[0]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private String errMessage(HasValue<?, ?> field, String message) {
        String id = this.getName(field);
        String m = !id.startsWith("_") ? this.form.getLabel(id) : Data.getLabel(field);
        if (m == null) {
            return message;
        }
        return m + ": " + message;
    }

    private /* synthetic */ Object lambda$addField$6d863fc3$3(String name, Object x) {
        return this.valueHandler.getValue(name);
    }

    private /* synthetic */ void lambda$addField$ccbb81d0$2(String name, Object d, Object v) {
        this.valueHandler.setValue(name, v);
    }

    private /* synthetic */ Object lambda$addField$6d863fc3$2(String name, Object x) {
        return this.valueHandler.getValue(name);
    }

    private /* synthetic */ void lambda$addField$ccbb81d0$1(String name, Object d, Object v) {
        this.setValue(name, v);
    }

    private /* synthetic */ Object lambda$addField$6d863fc3$1(String name, Object x) {
        return this.getValue(name);
    }

    private static class DataValidators<D, F>
    extends ArrayList<Validator<F>>
    implements Validator<D> {
        private final ValueContext valueContext;
        private final HasValue<?, F> field;

        private DataValidators(Binder binder, HasValue<?, F> field, Alert errorText) {
            this.field = field;
            this.valueContext = new ValueContext(binder, (Component)(field instanceof Component ? (Component)field : errorText), field);
        }

        public ValidationResult apply(D data, ValueContext valueContext) {
            Validator v;
            ValidationResult vr = OK;
            Iterator iterator = this.iterator();
            while (iterator.hasNext() && !(vr = (v = (Validator)iterator.next()).apply(this.field.getValue(), this.valueContext)).getErrorLevel().isPresent()) {
            }
            if (this.field == null) {
                return OK;
            }
            if (vr.getErrorLevel().isPresent()) {
                AbstractForm.markError(this.field);
            } else {
                AbstractForm.clearError(this.field);
            }
            return vr;
        }
    }

    private static class DataValidator<D, F>
    implements Validator<F> {
        private static final String INVALID = "Not valid";
        private final Function<F, Boolean> validator;
        private String errorMessage;
        private final Data<D> data;

        private DataValidator(Data<D> data, Function<F, Boolean> validator, String errorMessage) {
            this.data = data;
            this.validator = validator;
            if (errorMessage != null && !errorMessage.isEmpty()) {
                this.errorMessage = errorMessage;
            }
        }

        public ValidationResult apply(F value, ValueContext valueContext) {
            if (this.validator.apply(value).booleanValue()) {
                return OK;
            }
            HasValue field = valueContext.getHasValue().orElse(null);
            if (field == null) {
                return OK;
            }
            String m = this.errorMessage;
            if (m == null) {
                m = this.data.errMessage(field, INVALID);
            }
            return ValidationResult.error((String)m);
        }
    }

    private static class Required<D, F>
    implements Validator<F> {
        private static final String CAN_NOT_BE_EMPTY = "Can not be empty";
        private String errorMessage;
        private final Data<D> data;

        private Required(Data<D> data, String errorMessage) {
            this.data = data;
            if (errorMessage != null && !errorMessage.isEmpty()) {
                this.errorMessage = errorMessage;
            }
        }

        public ValidationResult apply(F value, ValueContext valueContext) {
            HasValue field = valueContext.getHasValue().orElse(null);
            if (field == null || !field.isEmpty()) {
                return OK;
            }
            String fieldName = this.data.getName(field);
            if (fieldName != null && this.data.valueHandler.canHandle(fieldName) && !this.data.valueHandler.canSet(fieldName)) {
                return OK;
            }
            String m = this.errorMessage;
            if (m == null) {
                m = this.data.errMessage(field, CAN_NOT_BE_EMPTY);
            }
            return ValidationResult.error((String)m);
        }
    }
}

