/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin.util;

import com.vaadin.flow.component.listbox.ListBox;
import com.vaadin.flow.component.listbox.dataview.ListBoxListDataView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class BasicComboList<T>
extends ListBox<T> {
    protected List<T> list;

    @SafeVarargs
    public BasicComboList(T ... list) {
        this((Collection<T>)Arrays.asList(list));
    }

    public BasicComboList(Collection<T> list) {
        this.setItems(list);
    }

    public ListBoxListDataView<T> setItems(Collection<T> items) {
        if (items == null) {
            return this.setItems(new ArrayList());
        }
        this.list = new ArrayList<T>(items);
        ListBoxListDataView r = (ListBoxListDataView)super.setItems(this.list);
        this.setFirstValue();
        return r;
    }

    protected void setFirstValue() {
        this.setValue(this.list.size() > 0 ? this.list.get(0) : null);
    }

    public int getIndex() {
        return this.getIndex(this.getValue());
    }

    public int getIndex(T item) {
        return this.list.indexOf(item);
    }

    public T getValue(int index) {
        return index < 0 || index >= this.list.size() ? null : (T)this.list.get(index);
    }

    public T getEmptyValue() {
        return null;
    }
}

