/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.Box;
import com.storedobject.vaadin.ButtonLayout;
import com.storedobject.vaadin.ClickHandler;
import com.storedobject.vaadin.DataForm;
import com.storedobject.vaadin.ImageButton;
import com.storedobject.vaadin.View;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import java.io.Serializable;

public class WindowDecorator
extends Composite<ButtonLayout> {
    private static final String COLOR = "var(--so-header-color)";
    private final ButtonLayout header = new ButtonLayout();
    private final Span titleText = new Span("");
    private final ImageButton close;

    public WindowDecorator(View view, Component ... headerComponents) {
        this.titleText.getStyle().set("color", COLOR).set("font-size", "var(--lumo-font-size-xl)").set("font-weight", "bold").set("padding", "0px").set("margin", "0px 0px 0px 2px").set("display", "flex").set("flex-grow", "100").set("text-overflow", "ellipsis");
        this.header.setWidthFull();
        this.close = new ImageButton(VaadinIcon.CLOSE, (ClickHandler)(view instanceof DataForm ? (ClickHandler & Serializable)e -> ((DataForm)view).cancel() : (ClickHandler & Serializable)e -> view.abort()));
        this.close.withBox();
        this.close.setColor(COLOR);
        this.header.add(new Component[]{this.titleText});
        if (headerComponents != null) {
            this.header.add(headerComponents);
        }
        this.close.getElement().setAttribute("title", view instanceof DataForm ? "Cancel" : "Close");
        this.header.add(new Component[]{this.close});
        this.close.getStyle().set("margin-right", "2px");
        Box box = new Box((Component)this.header);
        box.alignSizing();
        box.setStyle("background-color", "var(--so-header-background-50pct)");
        this.header.getStyle().set("flex-wrap", "nowrap");
        this.setCaption(view.getCaption());
        view.windowDecorator = this;
    }

    protected final ButtonLayout initContent() {
        return this.header;
    }

    public void setCaption(String caption) {
        this.titleText.setText(caption == null ? "" : caption);
    }

    public void setCloseable(boolean closeable) {
        this.close.setVisible(closeable);
    }
}

