/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.CloseableView;
import com.storedobject.vaadin.Scrollable;
import com.storedobject.vaadin.View;
import com.storedobject.vaadin.Window;
import com.storedobject.vaadin.WindowDecorator;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;

public class Viewer
extends View
implements CloseableView {
    public Viewer(String caption) {
        super(caption);
    }

    public Viewer(Component component, String caption, boolean windowMode) {
        this(caption);
        this.setComponent((Component)(windowMode ? this.createWindow(component) : component));
    }

    @Override
    protected Window createWindow(Component component) {
        Window w = new Window(new Component[]{this.createWindowDecorator(), component});
        w.setWidth(Math.min(95, Math.max(20, this.getViewWidth())) + "vw");
        w.setHeight(Math.min(95, Math.max(20, this.getViewWidth())) + "vh");
        if (component instanceof HasSize) {
            ((HasSize)component).setHeight("90%");
        }
        new Scrollable(component);
        return w;
    }

    protected WindowDecorator createWindowDecorator() {
        return new WindowDecorator(this, new Component[0]);
    }

    protected int getViewWidth() {
        return 80;
    }

    protected int getViewHeight() {
        return 80;
    }

    @Override
    public void decorateComponent() {
        super.decorateComponent();
        this.getComponent().getElement().getStyle().set("padding", "0px");
    }
}

