/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.Application;
import com.storedobject.vaadin.ApplicationMenuItem;
import com.storedobject.vaadin.CloseableView;
import com.storedobject.vaadin.ExecutableView;
import com.storedobject.vaadin.Scrollable;
import com.storedobject.vaadin.ViewClosedListener;
import com.storedobject.vaadin.ViewOpenedListener;
import com.storedobject.vaadin.Window;
import com.storedobject.vaadin.WindowDecorator;
import com.storedobject.vaadin.util.SupportWindowMode;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class View
implements ExecutableView {
    private static int DEFAULT_PADDING = 5;
    private Set<ViewClosedListener> closedListeners;
    private Set<ViewOpenedListener> openedListeners;
    private Component component;
    private boolean fullScreen = false;
    private String caption;
    private boolean aborted = false;
    private boolean detachParent = false;
    private View parent;
    private View embeddedView;
    private Registration windowMonitor;
    private boolean internalWindowAction = false;
    private boolean doFocus = true;
    private Component postFocus;
    private Focusable<?> firstFocus;
    private Application application;
    private ApplicationMenuItem menuItem;
    private Object createdBy;
    WindowDecorator windowDecorator;

    public View() {
        this(null);
    }

    public View(String caption) {
        this(null, caption);
    }

    public View(Component component, String caption) {
        this.getApplication();
        this.setCaption(caption);
        if (component != null) {
            this.setComponent(component);
        }
    }

    public static View createCloseableView(Component component, String caption) {
        class V
        extends View
        implements CloseableView {
            private V(Component component, String caption) {
                super(component, caption);
            }
        }
        return new V(component, caption);
    }

    public void setScrollable(boolean scrollable) {
        new Scrollable(this.getContent(), scrollable);
    }

    public boolean isScrollable() {
        return Scrollable.isScrollable(this.getContent());
    }

    public Component getContent() {
        return this.getContentInt();
    }

    private Component getContentInt() {
        Component c = this.getComponent();
        if (!(c instanceof Dialog)) {
            return c;
        }
        Optional oc = c.getChildren().findFirst();
        if (oc.isEmpty()) {
            return c;
        }
        if (c.getChildren().anyMatch(e -> e != oc.get())) {
            return c;
        }
        return (Component)oc.get();
    }

    protected void initUI() {
    }

    public final void setComponent(Component component) {
        SupportWindowMode swm;
        Window w;
        if (component == this.component || component == null) {
            return;
        }
        Element parent = this.parent();
        if (parent != null && !View.isChild(component, this.component)) {
            this.component.getElement().removeFromParent();
            if (this.component instanceof Window) {
                ((Window)this.component).close();
            }
            component.getElement().removeFromParent();
            parent.appendChild(new Element[]{component.getElement()});
        }
        this.component = component;
        if (component instanceof SupportWindowMode && (w = (swm = (SupportWindowMode)component).createWindow(this)) != null) {
            this.component = w;
        }
    }

    private static boolean isChild(Component parent, Component child) {
        if (child == null) {
            return false;
        }
        return parent.getChildren().anyMatch(c -> c == child || View.isChild(c, child));
    }

    public void decorateComponent() {
        Component c = this.getComponent();
        if (c instanceof Dialog) {
            return;
        }
        if (c instanceof HasSize) {
            ((HasSize)c).setSizeFull();
        }
        if (c instanceof Div) {
            c.getElement().getStyle().set("display", "flex").set("flex-direction", "column");
        }
        c.getElement().getStyle().set("padding", DEFAULT_PADDING + "px").set("box-sizing", "border-box");
    }

    private Element parent() {
        return this.component == null ? null : this.component.getElement().getParent();
    }

    public final Component getComponent() {
        if (this.component == null) {
            this.initUI();
        }
        if (this.component == null) {
            throw new RuntimeException("Component not set in View: " + this.getCaption());
        }
        Component component = this.component;
        if (component instanceof Dialog) {
            Dialog d = (Dialog)component;
            if (this.windowMonitor == null) {
                this.windowMonitor = d.addOpenedChangeListener((ComponentEventListener)new WindowMonitor(this));
            }
        }
        return this.component;
    }

    @Override
    public boolean isFullScreen() {
        return this.fullScreen || ExecutableView.super.isFullScreen();
    }

    public void setFullScreen(boolean fullScreen) {
        this.fullScreen = fullScreen;
    }

    void setVisibility(boolean visible) {
        Component component = this.component;
        if (component instanceof Dialog) {
            Dialog d = (Dialog)component;
            this.internalWindowAction = true;
            if (visible) {
                d.open();
            } else {
                d.close();
            }
        } else {
            this.component.setVisible(visible);
        }
        if (visible) {
            if (this.doFocus) {
                this.focus();
                this.doFocus = false;
            } else if (this.postFocus != null) {
                this.focus(this.postFocus, false);
                this.postFocus = null;
            } else {
                this.focus();
            }
        }
    }

    void setPostFocus(Component component) {
        this.postFocus = component;
    }

    public void setFirstFocus(Focusable<?> firstFocus) {
        this.firstFocus = firstFocus;
    }

    public boolean skipFirstFocus(Focusable<?> skipFocus) {
        return false;
    }

    public void focus() {
        if (this.firstFocus != null) {
            this.firstFocus.focus();
            return;
        }
        if (this.focus(this.getContent())) {
            return;
        }
        if (this.focusAny(this.getContent(), true)) {
            return;
        }
        if (this.focusAny(this.getContentInt(), true)) {
            return;
        }
        if (this.focusAny(this.getContent(), false)) {
            return;
        }
        this.focusAny(this.getContentInt(), false);
    }

    public boolean focus(Component component) {
        return this.focus(component, true);
    }

    private boolean focus(Component component, boolean checkSkip) {
        if (component instanceof HasComponents) {
            return component.getChildren().anyMatch(c -> this.focus((Component)c, checkSkip));
        }
        if (component instanceof HasValue && component instanceof Focusable) {
            Focusable focusable = (Focusable)component;
            if (!((HasValue)component).isReadOnly() && component.isVisible()) {
                if (!focusable.isEnabled() || checkSkip && this.skipFirstFocus(focusable)) {
                    return false;
                }
                focusable.focus();
                return true;
            }
        }
        return false;
    }

    public boolean focusAny(Component component) {
        return this.focusAny(component, false);
    }

    private boolean focusAny(Component component, boolean checkSkip) {
        if (component instanceof HasComponents) {
            return component.getChildren().anyMatch(c -> this.focusAny((Component)c, checkSkip));
        }
        if (component instanceof Focusable) {
            Focusable focusable = (Focusable)component;
            if (component.isVisible()) {
                if (!focusable.isEnabled() || checkSkip && this.skipFirstFocus(focusable)) {
                    return false;
                }
                focusable.focus();
                return true;
            }
        }
        return false;
    }

    public final ApplicationMenuItem getMenuItem() {
        return this.menuItem;
    }

    @Override
    public final ApplicationMenuItem getMenuItem(Runnable menuAction) {
        if (this.menuItem == null) {
            this.menuItem = ExecutableView.super.getMenuItem(menuAction);
            if (this.menuItem == null) {
                this.menuItem = ((Application)this.getApplication()).getEnvironment().createMenuItem(this, this.caption, menuAction);
            }
        }
        return this.menuItem;
    }

    @Override
    public void setCaption(String caption) {
        String string = this.caption = caption == null ? "" : caption;
        if (this.menuItem != null) {
            this.menuItem.setLabel(caption);
        }
        if (this.windowDecorator != null) {
            this.windowDecorator.setCaption(caption);
        }
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    public boolean isWindowMode() {
        return this.component instanceof Dialog;
    }

    public void setWindowMode(boolean windowOn) {
        Div nc;
        this.getComponent();
        if (this.windowMonitor != null) {
            this.windowMonitor.remove();
            this.windowMonitor = null;
        }
        if (windowOn) {
            if (this.component instanceof Dialog) {
                return;
            }
            boolean ex = this.executing();
            Component c = this.component;
            Window w = this.createWindow(c);
            if (w == null) {
                w = new Window(c);
            }
            this.setComponent((Component)w);
            if (ex) {
                w.setVisible(true);
            }
            return;
        }
        if (!(this.component instanceof Dialog)) {
            return;
        }
        ArrayList list = new ArrayList();
        this.component.getChildren().forEach(list::add);
        if (list.size() != 1) {
            nc = new Div();
            list.forEach(xva$0 -> nc.add(new Component[]{xva$0}));
        } else {
            nc = (Component)list.get(0);
        }
        ((Dialog)this.component).removeAll();
        this.setComponent((Component)nc);
    }

    protected Window createWindow(Component component) {
        return null;
    }

    public void setEmbeddedView(View embeddedView) {
        this.embeddedView = this.ev(embeddedView);
    }

    public final View getEmbeddedView() {
        return this.embeddedView == null ? this : this.ev(this.embeddedView);
    }

    private View ev(View p) {
        if (p == null || p.embeddedView == null) {
            return p;
        }
        if (p == this || p.embeddedView == this) {
            return null;
        }
        return this.ev(p);
    }

    @Override
    public View getView(boolean create) {
        return this.getEmbeddedView();
    }

    public boolean select() {
        return ((Application)this.getApplication()).select(this);
    }

    @Override
    public final void execute() {
        this.execute(null, true);
    }

    @Override
    public final void execute(View lock) {
        this.execute(lock, false);
    }

    @Override
    public final void invoke(View parent) {
        this.execute(parent, true);
    }

    protected void execute(View parent, boolean doNotLock) {
        if (this.getCaption() == null || this.getCaption().trim().isEmpty()) {
            throw new RuntimeException("Caption not set!");
        }
        if (this.parent != null && parent != null && this.parent != parent) {
            return;
        }
        this.parent = parent == null ? null : parent.getView(true);
        this.aborted = false;
        if (this.openedListeners != null) {
            this.openedListeners.forEach(listener -> listener.viewOpening(this));
        }
        ((Application)this.getApplication()).execute(this.getView(true), doNotLock, this.parent);
        if (this.openedListeners != null) {
            this.openedListeners.forEach(listener -> listener.viewOpened(this));
        }
    }

    @Override
    public <A extends Application> A getApplication() {
        if (this.application == null) {
            this.application = Application.get();
        }
        return (A)this.application;
    }

    public final boolean executing() {
        return this.component != null && ((Application)this.getApplication()).executing(this);
    }

    public final boolean aborted() {
        return this.aborted;
    }

    @Override
    public void close() {
        this.closeInt();
    }

    @Override
    public void abort() {
        this.aborted = true;
        this.closeInt();
    }

    @Override
    public void clean() {
    }

    void detachParentOnClose() {
        this.detachParent = true;
    }

    private void closeInt() {
        if (this.windowMonitor != null) {
            this.windowMonitor.remove();
            this.windowMonitor = null;
        }
        ((Application)this.getApplication()).close(this);
        if (this.detachParent && this.parent != null) {
            this.detachParent = false;
            View p = this.parent;
            this.parent = null;
            ((Application)this.getApplication()).close(p);
        } else {
            this.parent = null;
        }
        this.doFocus = true;
        this.clean();
        if (this.closedListeners != null) {
            new ArrayList<ViewClosedListener>(this.closedListeners).forEach(listener -> listener.viewClosed(this));
        }
    }

    public Registration addOpenedListener(ViewOpenedListener listener) {
        if (listener == null) {
            return null;
        }
        if (this.openedListeners == null) {
            this.openedListeners = new HashSet<ViewOpenedListener>();
        }
        this.openedListeners.add(listener);
        return (Registration & Serializable)() -> this.openedListeners.remove(listener);
    }

    public Registration addClosedListener(ViewClosedListener listener) {
        if (listener == null) {
            return null;
        }
        if (this.closedListeners == null) {
            this.closedListeners = new HashSet<ViewClosedListener>();
        }
        this.closedListeners.add(listener);
        return (Registration & Serializable)() -> this.closedListeners.remove(listener);
    }

    public static void setDefaultPadding(int padding) {
        DEFAULT_PADDING = padding;
    }

    public Object getCreatedBy() {
        return this.createdBy == null ? this : this.createdBy;
    }

    public void setCreatedBy(Object createdBy) {
        this.createdBy = createdBy;
    }

    private static class WindowMonitor
    implements ComponentEventListener<Dialog.OpenedChangeEvent> {
        private final View view;

        private WindowMonitor(View view) {
            this.view = view;
        }

        public void onComponentEvent(Dialog.OpenedChangeEvent dialogOpenedChangeEvent) {
            if (this.view.internalWindowAction) {
                this.view.internalWindowAction = false;
            } else if (!dialogOpenedChangeEvent.isOpened()) {
                ((Dialog)dialogOpenedChangeEvent.getSource()).open();
            }
        }
    }
}

