/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.helper.ID;
import com.storedobject.helper.LitComponent;
import com.storedobject.vaadin.Application;
import com.storedobject.vaadin.MediaCapture;
import com.storedobject.vaadin.Video;
import com.storedobject.vaadin.util.MediaStreamVariable;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamReceiver;
import com.vaadin.flow.server.StreamVariable;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonFactory;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JreJsonFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VideoCapture
extends Video
implements MediaCapture {
    private final Camera camera;
    private boolean frontCamera = false;
    private List<MediaCapture.StatusChangeListener> statusChangeListeners;
    private Application application;

    public VideoCapture() {
        this((Image)null);
    }

    public VideoCapture(Image image) {
        ID.set((Component)this);
        this.camera = new Camera();
        this.getElement().appendChild(new Element[]{this.camera.getElement()});
        this.camera.getElement().setAttribute("videoid", this.getId().orElse(""));
        this.attachImage(image);
    }

    @Override
    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.application == null) {
            this.getApplication();
        }
        this.camera.recording = (byte)-1;
        this.camera.previewing = (byte)-1;
        this.setCameraOptions();
    }

    @Override
    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        boolean changed = this.camera.previewing == 1 || this.camera.recording == 1;
        this.camera.recording = (byte)-1;
        this.camera.previewing = (byte)-1;
        if (changed) {
            this.fireStatusChange();
        }
    }

    public void selectFrontCamera() {
        this.frontCamera = true;
    }

    public void selectRearCamera() {
        this.frontCamera = false;
    }

    private void setCameraOptions() {
        HashMap<String, Object> previewOpts = new HashMap<String, Object>();
        previewOpts.put("audio", false);
        HashMap<String, String> videoP = new HashMap<String, String>();
        videoP.put("facingMode", this.frontCamera ? "user" : "environment");
        previewOpts.put("video", videoP);
        HashMap<String, Object> recOpts = new HashMap<String, Object>();
        recOpts.put("audio", true);
        HashMap<String, String> videoR = new HashMap<String, String>();
        videoR.put("facingMode", this.frontCamera ? "user" : "environment");
        recOpts.put("video", videoR);
        this.camera.setOptions(previewOpts, recOpts);
    }

    @Override
    public Application getApplication() {
        if (this.application == null) {
            this.application = Application.get();
        }
        return this.application;
    }

    public void attachImage(Image image) {
        this.camera.connect(image);
    }

    public void preview() {
        this.camera.showPreview();
    }

    public void previewPicture() {
        this.camera.takePicture(null, false);
    }

    public void previewPicture(Image image) {
        this.camera.takePicture(image, false);
    }

    public void savePicture(MediaCapture.DataReceiver dataReceiver) {
        this.camera.setReceiver(dataReceiver);
        this.camera.takePicture(null, true);
    }

    public void savePicture(Image image, MediaCapture.DataReceiver dataReceiver) {
        this.camera.setReceiver(dataReceiver);
        this.camera.takePicture(image, true);
    }

    @Override
    public void startRecording(MediaCapture.DataReceiver dataReceiver) {
        this.camera.setReceiver(dataReceiver);
        this.camera.startRecording();
    }

    @Override
    public boolean isRecording() {
        return this.camera.recording == 1;
    }

    @Override
    public void stopRecording() {
        this.camera.stopRecording();
    }

    @Override
    public boolean isPreviewing() {
        return this.camera.previewing == 1;
    }

    @Override
    public void stopDevice() {
        this.camera.stopCamera();
    }

    @Override
    public Registration addStatusChangeListener(MediaCapture.StatusChangeListener listener) {
        if (listener == null) {
            return null;
        }
        if (this.statusChangeListeners == null) {
            this.statusChangeListeners = new ArrayList<MediaCapture.StatusChangeListener>();
        }
        this.statusChangeListeners.add(listener);
        return (Registration & Serializable)() -> this.statusChangeListeners.remove(listener);
    }

    private void fireStatusChange() {
        if (this.statusChangeListeners != null) {
            this.statusChangeListeners.forEach(l -> l.statusChanged(this));
        }
    }

    @Tag(value="so-camera")
    @JsModule(value="./so/media/camera.js")
    private class Camera
    extends LitComponent {
        private final String STOP_CAMERA = "stopCamera";
        private final String START_RECORDING = "startRecording";
        private final String TAKE_PICTURE = "takePicture";
        private final String PREVIEW_PICTURE = "previewPicture";
        private final String SHOW_PREVIEW = "showPreview";
        private byte previewing = 0;
        private byte recording = 0;
        private final List<String> commands = new ArrayList<String>();
        private volatile boolean done = true;
        private String prevCommand;

        private Camera() {
            ID.set((Component)this);
            this.getElement().setAttribute("canvasid", "canvas" + ID.newID());
        }

        @ClientCallable
        private void previewingStatus(int status) {
            this.previewing = (byte)status;
            this.recording = (byte)-1;
            VideoCapture.this.fireStatusChange();
        }

        @ClientCallable
        private void recordingStatus(int status) {
            this.recording = (byte)status;
            this.previewing = (byte)-1;
            VideoCapture.this.fireStatusChange();
        }

        private void connect(Image image) {
            if (image != null) {
                String iid = image.getId().orElse(null);
                if (iid == null) {
                    ID.set((Component)image);
                    iid = image.getId().orElse(null);
                }
                this.getElement().setAttribute("imageid", iid);
            }
        }

        private void takePicture(Image image, boolean save) {
            this.connect(image);
            this.js(save ? "takePicture" : "previewPicture");
        }

        private void setOptions(Map<String, Object> previewOptions, Map<String, Object> recordingOptions) {
            JreJsonFactory factory = new JreJsonFactory();
            this.getElement().setPropertyJson("previewOptions", this.toJson(previewOptions, (JsonFactory)factory));
            this.getElement().setPropertyJson("recordingOptions", this.toJson(recordingOptions, (JsonFactory)factory));
        }

        private JsonValue toJson(Map<String, Object> map, JsonFactory factory) {
            JsonObject obj = factory.createObject();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getValue() instanceof Boolean) {
                    obj.put(entry.getKey(), (JsonValue)factory.create(((Boolean)entry.getValue()).booleanValue()));
                    continue;
                }
                if (entry.getValue() instanceof Double) {
                    obj.put(entry.getKey(), (JsonValue)factory.create(((Double)entry.getValue()).doubleValue()));
                    continue;
                }
                if (entry.getValue() instanceof Integer) {
                    obj.put(entry.getKey(), (JsonValue)factory.create((double)((Integer)entry.getValue()).intValue()));
                    continue;
                }
                if (entry.getValue() instanceof String) {
                    obj.put(entry.getKey(), (JsonValue)factory.create((String)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof Map) {
                    obj.put(entry.getKey(), this.toJson((Map)entry.getValue(), factory));
                    continue;
                }
                throw new IllegalArgumentException();
            }
            return obj;
        }

        private void setReceiver(MediaCapture.DataReceiver receiver) {
            this.getElement().setAttribute("target", (AbstractStreamResource)new StreamReceiver(this.getElement().getNode(), "camera" + ID.newID(), (StreamVariable)new MediaStreamVariable(receiver)));
        }

        private void startRecording() {
            this.js("startRecording");
        }

        private void stopRecording() {
            this.js("stopRecording");
        }

        private void stopCamera() {
            this.js("stopCamera");
        }

        private void showPreview() {
            this.js("showPreview");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ClientCallable
        private void done() {
            List<String> list = this.commands;
            synchronized (list) {
                if (this.commands.isEmpty()) {
                    this.done = true;
                    return;
                }
                this.done = false;
                String command = this.commands.remove(0);
                if (this.commands.contains("stopCamera")) {
                    this.done();
                    return;
                }
                this._js(command);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void js(String js) {
            List<String> list = this.commands;
            synchronized (list) {
                if (this.done) {
                    this.done = false;
                    this._js(js);
                    return;
                }
                this.commands.add(js);
            }
        }

        private void _js(String js) {
            switch (js) {
                case "stopCamera": {
                    if (!"stopCamera".equals(this.prevCommand)) break;
                    this.done();
                    return;
                }
                case "showPreview": {
                    if (VideoCapture.this.isVisible() && this.previewing != 1 && !VideoCapture.this.getParent().isEmpty()) break;
                    this.done();
                    return;
                }
                case "takePicture": 
                case "previewPicture": {
                    if (VideoCapture.this.isVisible() && this.previewing == 1) break;
                    this.done();
                    return;
                }
                case "startRecording": {
                    if (VideoCapture.this.isVisible() && this.recording != 1 && !VideoCapture.this.getParent().isEmpty()) break;
                    this.done();
                    return;
                }
            }
            this.executeJS(js, new Serializable[0]);
            this.prevCommand = js;
        }
    }
}

