/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.Application;
import com.storedobject.vaadin.Box;
import com.storedobject.vaadin.CustomField;
import com.storedobject.vaadin.StyledText;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.streams.UploadEvent;
import com.vaadin.flow.server.streams.UploadHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

@CssImport(value="./so/upload/styles.css", themeFor="vaadin-upload-file")
public class UploadField
extends CustomField<Integer> {
    private final Upload upload;
    private final Handler handler = new Handler();
    private int fileCount = 0;
    private int maxFileCount = Integer.MAX_VALUE;
    private final BiConsumer<InputStream, String> processor;
    private String fileName;
    private final Div description = new Div();
    private Application application;
    private UI ui;
    private Consumer<Throwable> processErrorConsumer;

    public UploadField() {
        this(null, null);
    }

    public UploadField(String label) {
        this(label, null);
    }

    public UploadField(BiConsumer<InputStream, String> processor) {
        this(null, processor);
    }

    public UploadField(String label, BiConsumer<InputStream, String> processor) {
        super(0);
        this.upload = new Upload((UploadHandler)this.handler);
        Component component = this.upload.getUploadButton();
        if (component instanceof Button) {
            Button b = (Button)component;
            b.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        }
        this.upload.setMaxFiles(this.maxFileCount);
        this.upload.setMaxFileSize(10000000);
        this.upload.addFileRejectedListener((ComponentEventListener & Serializable)e -> this.inform("File Rejected - " + e.getErrorMessage()));
        this.upload.addAllFinishedListener((ComponentEventListener & Serializable)e -> this.inform(null));
        this.add(new Component[]{this.upload, this.description});
        this.setLabel(label);
        this.processor = processor;
    }

    private void inform(String m) {
        if (this.getU() == null) {
            return;
        }
        this.ui.access((Command & Serializable)() -> this.inf(m));
    }

    private void inf(String m) {
        String s = "Files: " + this.fileCount;
        if (this.maxFileCount < Integer.MAX_VALUE) {
            s = s + "/" + this.maxFileCount;
        }
        if (m != null) {
            s = s + " - " + m;
        }
        this.description.setText(s);
        if (this.fileCount >= this.maxFileCount) {
            this.setReadOnly(true);
        }
    }

    public Upload getUploadComponent() {
        return this.upload;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.application = Application.get(this.getU());
    }

    private UI getU() {
        if (this.ui == null) {
            this.ui = this.getUI().orElse(null);
        }
        return this.ui;
    }

    public void setValue(Integer value) {
        super.setValue((Object)this.fileCount);
    }

    public void showDescription(boolean show) {
        this.description.setVisible(show);
    }

    public void setDescription(String description) {
        if (this.getU() == null) {
            this.description.setText(description);
        } else {
            this.ui.access((Command & Serializable)() -> this.description.setText(description));
        }
    }

    protected Integer generateModelValue() {
        return this.fileCount;
    }

    protected void setPresentationValue(Integer integer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUpload(UploadEvent event) {
        if (this.application != null) {
            this.application.startPolling((Object)this);
        }
        try {
            this.fileName = event.getFileName();
            InputStream in = event.getInputStream();
            try {
                this.process(in, event.getContentType());
                ++this.fileCount;
                this.inform(null);
                this.handler.responseHandled(true, event.getResponse());
            }
            catch (Throwable processingError) {
                if (this.processErrorConsumer != null) {
                    this.processErrorConsumer.accept(processingError);
                    this.ui.access((Command & Serializable)() -> this.setReadOnly(true));
                } else {
                    processingError.printStackTrace();
                    if (this.application != null) {
                        this.application.log(processingError);
                    } else {
                        processingError.printStackTrace();
                    }
                    StyledText error = new StyledText("<span style=\"color:red\">Processing error!</span>");
                    this.ui.access((Command & Serializable)() -> {
                        this.add(new Component[]{error});
                        this.setReadOnly(true);
                    });
                }
                this.handler.responseHandled(false, event.getResponse());
            }
            try {
                while (in.read() != -1) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.fileCount == this.maxFileCount) {
                this.ui.access((Command & Serializable)() -> {
                    new Box((Component)this.description);
                    this.setReadOnly(true);
                });
            }
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            if (this.application != null) {
                this.application.stopPolling((Object)this);
            }
        }
    }

    public void process(InputStream data, String mimeType) {
        if (this.processor != null) {
            this.processor.accept(data, mimeType);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setMaxFiles(int fileCount) {
        this.maxFileCount = fileCount <= 0 ? 1 : fileCount;
        this.upload.setMaxFiles(this.maxFileCount);
    }

    public final int getMaxFiles() {
        return this.maxFileCount;
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        if (readOnly) {
            this.upload.setVisible(false);
            this.description.setVisible(true);
        } else if (this.fileCount < this.maxFileCount) {
            this.upload.setVisible(true);
        }
    }

    public void setProcessErrorConsumer(Consumer<Throwable> processErrorConsumer) {
        this.processErrorConsumer = processErrorConsumer;
    }

    private class Handler
    implements UploadHandler {
        private Handler() {
        }

        public void handleUploadRequest(UploadEvent uploadEvent) {
            UploadField.this.handleUpload(uploadEvent);
        }
    }
}

