/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.CustomField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import java.io.Serializable;
import java.util.function.BiFunction;

public class TranslatedField<T, I>
extends CustomField<T> {
    private final HasValue<?, I> field;
    private final BiFunction<HasValue<?, I>, T, I> convertT2I;
    private final BiFunction<HasValue<?, I>, I, T> convertI2T;

    public TranslatedField(HasValue<?, I> field, BiFunction<HasValue<?, I>, I, T> convertToValue, BiFunction<HasValue<?, I>, T, I> convertToInternalValue) {
        this(field, convertToValue, convertToInternalValue, convertToValue.apply(field, field.getEmptyValue()));
    }

    public TranslatedField(HasValue<?, I> field, BiFunction<HasValue<?, I>, I, T> convertToValue, BiFunction<HasValue<?, I>, T, I> convertToInternalValue, T emptyValue) {
        super(emptyValue);
        this.field = field;
        this.convertT2I = convertToInternalValue;
        this.convertI2T = convertToValue;
        if (field instanceof Component) {
            if (field instanceof HasSize) {
                ((HasSize)field).setWidthFull();
            }
            this.add(new Component[]{(Component)field});
        }
        this.setPresentationValue(this.getEmptyValue());
        field.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.setModelValue(this.generateModelValue(), e.isFromClient()));
    }

    protected T generateModelValue() {
        Object v = null;
        Object i = this.field.getValue();
        if (i != null) {
            v = this.convertI2T.apply(this.field, i);
        }
        return (T)(v == null ? this.getEmptyValue() : v);
    }

    protected void setPresentationValue(T value) {
        this.field.setValue(this.convertT2I.apply(this.field, (HasValue<?, I>)value));
    }

    public HasValue<?, I> getField() {
        return this.field;
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.field.setReadOnly(readOnly);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.field instanceof HasEnabled) {
            ((HasEnabled)this.field).setEnabled(enabled);
        }
    }

    public boolean isInvalid() {
        if (this.field instanceof HasValidation) {
            return ((HasValidation)this.field).isInvalid();
        }
        return false;
    }
}

