/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.RequiredField;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.combobox.MultiSelectComboBox;
import com.vaadin.flow.data.provider.ListDataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public class TokensField<T>
extends MultiSelectComboBox<T>
implements RequiredField {
    public TokensField() {
        this((String)null);
    }

    public TokensField(String label) {
        this(label, (Collection)null);
    }

    public TokensField(Collection<T> items) {
        this(null, items);
    }

    public TokensField(String label, Collection<T> items) {
        this(label, items, null);
    }

    public TokensField(ItemLabelGenerator<T> itemLabelGenerator) {
        this(null, null, itemLabelGenerator);
    }

    public TokensField(String label, ItemLabelGenerator<T> itemLabelGenerator) {
        this(label, null, itemLabelGenerator);
    }

    public TokensField(String label, Collection<T> items, ItemLabelGenerator<T> itemLabelGenerator) {
        super(label, (Collection)(items == null ? new ArrayList() : items));
        if (itemLabelGenerator != null) {
            this.setItemLabelGenerator(itemLabelGenerator);
        }
    }

    protected boolean valueEquals(Set<T> value1, Set<T> value2) {
        if (Objects.equals(value1, value2)) {
            return true;
        }
        if (value1 == null || value2 == null || value1.size() != value2.size()) {
            return false;
        }
        for (T v : value1) {
            if (value2.contains(v)) continue;
            return false;
        }
        return true;
    }

    public void addValue(Set<T> value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        HashSet<T> v = new HashSet<T>();
        v.addAll(this.getValue());
        v.addAll(value);
        this.setValue((Set<T>)v);
    }

    public void addItems(Collection<T> items) {
        if (items == null || items.isEmpty()) {
            return;
        }
        this.addItems(items.stream());
    }

    @SafeVarargs
    public final void addItems(T ... items) {
        if (items == null || items.length == 0) {
            return;
        }
        this.addItems(Stream.of(items));
    }

    public void addItems(Stream<T> streamOfItems) {
        if (streamOfItems == null) {
            return;
        }
        ArrayList<T> items = new ArrayList<T>(this.items());
        streamOfItems.forEach(items::add);
        this.setItems(items);
    }

    public void setValue(Set<T> value) {
        if (value == null) {
            value = new HashSet<T>();
        }
        super.setValue(value);
    }

    public void setValue(Collection<T> value) {
        this.setValue((Set<T>)new HashSet<T>(value));
    }

    public void selectAll() {
        this.setValue((Set<T>)new HashSet<T>(this.items()));
    }

    public void deselectAll() {
        this.setValue(Set.of());
    }

    private Collection<T> items() {
        return ((ListDataProvider)this.getDataProvider()).getItems();
    }
}

