/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.TokensField;
import com.storedobject.vaadin.TranslatedField;
import com.vaadin.flow.component.HasValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TokenChoicesField
extends TranslatedField<Integer, Set<String>> {
    private static final Integer ZERO = 0;
    private int valueMask;

    public TokenChoicesField(String choices) {
        this(null, choices);
    }

    public TokenChoicesField(String label, String choices) {
        this(label, Arrays.asList(choices.split(",")));
    }

    public TokenChoicesField(String[] choices) {
        this(null, choices);
    }

    public TokenChoicesField(String label, String[] choices) {
        this(label, Arrays.asList(choices));
    }

    public TokenChoicesField(Iterable<?> choices) {
        this(null, choices);
    }

    public TokenChoicesField(String label, Iterable<?> choices) {
        this(label, TokenChoicesField.createList(choices));
    }

    public TokenChoicesField(String label, Collection<String> choices) {
        this(label, TokenChoicesField.createList(choices));
    }

    private TokenChoicesField(String label, List<String> choices) {
        super(new TField(choices), (f, s) -> ((TField)f).toValue((Set<String>)s), (f, i) -> ((TField)f).toSet((int)i), ZERO);
        this.setLabel(label);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.checkMask((Integer)e.getValue()));
    }

    private void checkMask(int newValue) {
        if ((newValue & this.valueMask) != this.valueMask) {
            this.setValue(newValue | this.valueMask);
        }
    }

    private static List<String> createList(Iterable<?> list) {
        ArrayList<String> a = new ArrayList<String>();
        list.forEach(item -> {
            String s = null;
            if (item != null) {
                s = item.toString();
            }
            if (s != null) {
                a.add(s);
            }
        });
        return a;
    }

    public void setValueMask(int valueMask) {
        this.valueMask = valueMask;
        this.checkMask((Integer)this.getValue());
    }

    private static class TField
    extends TokensField<String> {
        private final List<String> choices;

        private TField(List<String> choices) {
            super(choices);
            this.choices = choices;
            this.setLabel(null);
        }

        private int toValue(Set<String> set) {
            int v = 0;
            for (int i = this.choices.size() - 1; i >= 0; --i) {
                v <<= 1;
                if (!set.contains(this.choices.get(i))) continue;
                v |= 1;
            }
            return v;
        }

        private Set<String> toSet(int i) {
            HashSet<String> s = new HashSet<String>();
            for (int p = 0; i > 0 && p < this.choices.size(); i >>= 1, ++p) {
                if ((i & 1) != 1) continue;
                s.add(this.choices.get(p));
            }
            return s;
        }
    }
}

