/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.HasStyle;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;

@Tag(value="paper-toggle-button")
@NpmPackage(value="@polymer/paper-toggle-button", version="3.0.1")
@JsModule(value="@polymer/paper-toggle-button/paper-toggle-button.js")
public class ToggleButton
extends AbstractSinglePropertyField<ToggleButton, Boolean>
implements HasStyle {
    public ToggleButton() {
        this(false);
    }

    public ToggleButton(boolean initialValue) {
        super("checked", (Object)false, false);
        if (initialValue) {
            this.setValue(true);
        }
        this.activate();
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly == this.isReadOnly()) {
            return;
        }
        super.setReadOnly(readOnly);
        if (readOnly) {
            this.deactivate();
        } else {
            this.activate();
        }
    }

    public void setEnabled(boolean enabled) {
        this.setReadOnly(!enabled);
    }

    private void activate() {
        this.getElement().getStyle().set("--paper-toggle-button-checked-bar-color", "var(--lumo-primary-color)").set("--paper-toggle-button-unchecked-bar-color", "var(--lumo-primary-color)").set("--paper-toggle-button-checked-button-color", "var(--lumo-primary-color)").set("--paper-toggle-button-checked-ink-color", "var(--lumo-primary-color-50pct)").set("--paper-toggle-button-unchecked-ink-color", "var(--lumo-primary-color-50pct)");
    }

    private void deactivate() {
        this.getElement().getStyle().set("--paper-toggle-button-checked-bar-color", "var(--lumo-contrast-50pct)").set("--paper-toggle-button-unchecked-bar-color", "var(--lumo-contrast-50pct)").set("--paper-toggle-button-checked-button-color", "var(--lumo-primary-color-50pct)").set("--paper-toggle-button-unchecked-button-color", "var(--lumo-contrast-50pct)").set("--paper-toggle-button-checked-ink-color", "var(--lumo-base-color)").set("--paper-toggle-button-unchecked-ink-color", "var(--lumo-base-color)");
    }
}

