/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.helper.LitComponent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.template.Id;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Tag(value="so-timer")
@JsModule(value="./so/timer/so-timer.js")
public class TimerComponent
extends LitComponent
implements HasStyle {
    private final List<Listener> listeners = new ArrayList<Listener>();
    @Id
    private Span span;

    public TimerComponent() {
        this.executeJS("initComp", new Serializable[0]);
    }

    public Registration addListener(Listener listener) {
        this.listeners.add(listener);
        return (Registration & Serializable)() -> this.listeners.remove(listener);
    }

    @ClientCallable
    private void completed() {
        this.listeners.forEach(listener -> listener.completed(this));
    }

    public void countUp(int seconds) {
        this.countDown(-seconds);
    }

    public void countDown(int seconds) {
        this.executeJS("count", new Serializable[]{Integer.valueOf(-seconds)});
    }

    public void abort() {
        this.countDown(0);
    }

    public void setPrefix(String prefix) {
        this.executeJS("setDPrefix", new Serializable[]{prefix});
    }

    public void setSuffix(String suffix) {
        this.executeJS("setDSuffix", new Serializable[]{suffix});
    }

    public Style getStyle() {
        return this.span.getStyle();
    }

    @FunctionalInterface
    public static interface Listener {
        public void completed(TimerComponent var1);
    }
}

