/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.dom.Element;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum ThemeStyle {
    SUCCESS,
    ERROR,
    PILL,
    CONTRAST,
    SMALL,
    PRIMARY,
    ICON,
    BADGE;

    private static final String THEME = "theme";

    public String toString() {
        return super.toString().toLowerCase();
    }

    public static void set(HasElement component, ThemeStyle ... styles) {
        ThemeStyle.set(component.getElement(), styles);
    }

    public static void set(Element element, ThemeStyle ... styles) {
        if (styles == null || styles.length == 0) {
            ThemeStyle.clear(element);
        } else {
            element.setAttribute(THEME, Arrays.stream(styles).map(Enum::toString).collect(Collectors.joining(" ")));
        }
    }

    public static void add(HasElement component, ThemeStyle ... styles) {
        ThemeStyle.add(component.getElement(), styles);
    }

    public static void add(Element element, ThemeStyle ... styles) {
        String theme = element.getAttribute(THEME);
        if (theme != null) {
            theme = theme.trim();
        }
        if (theme == null || theme.isEmpty()) {
            ThemeStyle.set(element, styles);
            return;
        }
        String oldSet = " " + theme + " ";
        String newSet = Arrays.stream(styles).map(Enum::toString).filter(s -> !oldSet.contains((CharSequence)s)).collect(Collectors.joining(" "));
        if (!newSet.isEmpty()) {
            element.setAttribute(THEME, theme + " " + newSet);
        }
    }

    public static void clear(HasElement component) {
        ThemeStyle.clear(component.getElement());
    }

    public static void clear(Element element) {
        element.removeAttribute(THEME);
    }

    public static void remove(HasElement component, ThemeStyle ... styles) {
        ThemeStyle.remove(component.getElement(), styles);
    }

    public static void remove(Element element, ThemeStyle ... styles) {
        Object theme = element.getAttribute(THEME);
        if (theme != null) {
            theme = ((String)theme).trim();
        }
        if (theme == null || ((String)theme).isEmpty() || styles == null || styles.length == 0) {
            return;
        }
        theme = " " + (String)theme + " ";
        for (ThemeStyle s : styles) {
            theme = ((String)theme).replace(" " + String.valueOf((Object)s) + " ", " ");
        }
        if (((String)(theme = ((String)theme).trim())).isEmpty()) {
            element.removeAttribute(THEME);
        } else {
            element.setAttribute(THEME, (String)theme);
        }
    }
}

