/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.DisablePaste;
import com.storedobject.vaadin.Icon;
import com.storedobject.vaadin.RequiredField;
import com.storedobject.vaadin.ValueRequired;
import com.storedobject.vaadin.util.HasTextValue;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.dom.Element;

@CssImport(value="./so/textfield/styles.css", themeFor="vaadin-text-field")
public class TextField
extends com.vaadin.flow.component.textfield.TextField
implements HasTextValue,
DisablePaste,
RequiredField,
ValueRequired {
    private int inputType = 0;

    public TextField() {
        this.setSpellCheck(false);
    }

    public TextField(String label) {
        super(label);
        this.setSpellCheck(false);
        this.isRequired();
    }

    public TextField(String label, String placeholder) {
        super(label, placeholder);
        this.setSpellCheck(false);
    }

    public TextField(String label, String initialValue, String placeholder) {
        super(label, initialValue, placeholder);
        this.setSpellCheck(false);
    }

    public void setIcon(Icon icon) {
        icon.getElement().setAttribute("slot", "prefix");
        this.getElement().appendChild(new Element[]{icon.getElement()});
    }

    public void setIcon(String icon) {
        this.setIcon(new Icon(icon));
    }

    @Override
    public void setValue(String value) {
        super.setValue(value == null ? "" : value);
    }

    @Override
    public String getText() {
        return this.getValue();
    }

    @Override
    public void setText(String text) {
        this.setValue(text);
    }

    @Override
    public void inputTypeSet(int type) {
        this.inputType = type;
    }

    @Override
    public String getValue() {
        String v = super.getValue();
        return switch (this.inputType) {
            case 1 -> v.toLowerCase();
            case 2 -> v.toUpperCase();
            case 3 -> HasTextValue.camelcase(v);
            default -> v;
        };
    }
}

