/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.util.HasTextValue;
import com.vaadin.flow.component.dependency.CssImport;

@CssImport(value="./so/textarea/styles.css", themeFor="vaadin-text-area")
public class TextArea
extends com.vaadin.flow.component.textfield.TextArea
implements HasTextValue {
    private int inputType = 0;

    public TextArea() {
    }

    public TextArea(String label) {
        super(label);
    }

    public TextArea(String label, String placeholder) {
        super(label, placeholder);
    }

    public TextArea(String label, String initialValue, String placeholder) {
        super(label, initialValue, placeholder);
    }

    public TextArea(int rows, int columns) {
        this.setRows(rows);
        this.setColumns(columns);
    }

    public TextArea(String label, int rows, int columns) {
        super(label);
        this.setRows(rows);
        this.setColumns(columns);
    }

    public TextArea(String label, String placeholder, int rows, int columns) {
        super(label, placeholder);
        this.setRows(rows);
        this.setColumns(columns);
    }

    public TextArea(String label, String initialValue, String placeholder, int rows, int columns) {
        super(label, initialValue, placeholder);
        this.setRows(rows);
        this.setColumns(columns);
    }

    public TextArea(int rows) {
        this.setRows(rows);
    }

    public TextArea(String label, int rows) {
        super(label);
        this.setRows(rows);
    }

    public TextArea(String label, String placeholder, int rows) {
        super(label, placeholder);
        this.setRows(rows);
    }

    public TextArea(String label, String initialValue, String placeholder, int rows) {
        super(label, initialValue, placeholder);
        this.setRows(rows);
    }

    public void setRows(int minimumVisibleRows) {
        if (minimumVisibleRows < 2) {
            return;
        }
        this.setHeight(minimumVisibleRows * 28 + "px");
    }

    public void setColumns(int minimumVisibleColumns) {
        if (minimumVisibleColumns < 5) {
            return;
        }
        this.setWidth(minimumVisibleColumns + "em");
    }

    @Override
    public void setValue(String value) {
        super.setValue(value == null ? "" : value);
    }

    @Override
    public void setPattern(String pattern) {
    }

    @Override
    public String getText() {
        return this.getValue();
    }

    @Override
    public void setText(String text) {
        this.setValue(text);
    }

    @Override
    public void inputTypeSet(int type) {
        this.inputType = type;
    }

    @Override
    public String getValue() {
        String v = super.getValue();
        return switch (this.inputType) {
            case 1 -> v.toLowerCase();
            case 2 -> v.toUpperCase();
            case 3 -> HasTextValue.camelcase(v);
            default -> v;
        };
    }
}

