/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class Tabs
extends Composite<Div> {
    private final Div container = new Div();
    private final com.vaadin.flow.component.tabs.Tabs tabs;
    private List<ComponentEventListener<SelectedChangeEvent>> listeners;
    private final Map<Tab, List<Component>> componentMap = new HashMap<Tab, List<Component>>();

    public Tabs() {
        this.container.getStyle().set("display", "flex").set("flex-direction", "column");
        this.container.setSizeFull();
        this.tabs = new com.vaadin.flow.component.tabs.Tabs(false, new Tab[0]);
        this.tabs.addSelectedChangeListener((ComponentEventListener & Serializable)e -> {
            SelectedChangeEvent sce = new SelectedChangeEvent(this, e.getPreviousTab(), e.isFromClient());
            this.tabSelected(sce.selectedTab);
            if (this.listeners != null) {
                this.listeners.forEach(listener -> listener.onComponentEvent((ComponentEvent)sce));
            }
        });
        this.container.add(new Component[]{this.tabs});
    }

    protected final Div initContent() {
        return this.container;
    }

    protected Div getContainer() {
        return this.container;
    }

    public com.vaadin.flow.component.tabs.Tabs getTabs() {
        return this.tabs;
    }

    protected void tabSelected(Tab selected) {
        this.container.getChildren().filter(c -> c != this.tabs).forEach(xva$0 -> this.container.remove(new Component[]{xva$0}));
        if (selected == null) {
            return;
        }
        this.getChildren(selected).forEach(xva$0 -> this.container.add(new Component[]{xva$0}));
    }

    protected Stream<Component> getChildren(Tab tab) {
        return this.componentMap.get(tab).stream();
    }

    public Tab createTab(String tabLabel, Component ... components) {
        Tab tab = new Tab(tabLabel);
        this.add(tab, components);
        return tab;
    }

    public void add(Tab tab, Component ... components) {
        List<Component> componentList = this.componentMap.get(tab);
        if (componentList != null) {
            Collections.addAll(componentList, components);
            if (this.tabs.getSelectedTab() == tab) {
                this.tabSelected(tab);
            }
            return;
        }
        componentList = new ArrayList<Component>();
        Collections.addAll(componentList, components);
        this.componentMap.put(tab, componentList);
        boolean first = this.tabs.getTabCount() == 0;
        this.tabs.add(new Tab[]{tab});
        if (first) {
            this.setSelectedTab(tab);
        }
    }

    public void remove(Tab ... tabs) {
        for (Tab tab : tabs) {
            this.getChildren(tab).forEach(xva$0 -> this.container.remove(new Component[]{xva$0}));
            this.componentMap.remove(tab);
        }
        this.tabs.remove(tabs);
    }

    public void removeAll() {
        this.componentMap.clear();
        this.container.removeAll();
        this.tabs.removeAll();
    }

    public void replace(Tab oldTab, Tab newTab) {
        this.tabs.replace(oldTab, newTab);
        List<Component> components = this.componentMap.get(oldTab);
        this.componentMap.remove(oldTab);
        this.componentMap.put(newTab, components);
    }

    public Tab getSelectedTab() {
        return this.tabs.getSelectedTab();
    }

    public void setSelectedTab(Tab tab) {
        this.tabs.setSelectedTab(tab);
    }

    public void setSelectedTab(Component component) {
        this.setSelectedTab(this.getTab(component));
    }

    public int getSelectedIndex() {
        return this.tabs.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        this.tabs.setSelectedIndex(index);
    }

    public Tab getTab(Component component) {
        return this.componentMap.entrySet().stream().filter(set -> ((List)set.getValue()).contains(component)).map(Map.Entry::getKey).findAny().orElse(null);
    }

    public Registration addSelectedChangeListener(ComponentEventListener<SelectedChangeEvent> listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ComponentEventListener<SelectedChangeEvent>>();
        }
        this.listeners.add(listener);
        return (Registration & Serializable)() -> this.listeners.remove(listener);
    }

    public void setOrientation(Tabs.Orientation orientation) {
        this.tabs.setOrientation(orientation);
    }

    public Tabs.Orientation getOrientation() {
        return this.tabs.getOrientation();
    }

    public static class SelectedChangeEvent
    extends ComponentEvent<Tabs> {
        private final Tab selectedTab;
        private final Tab previousTab;
        private final boolean initialSelection;

        public SelectedChangeEvent(Tabs source, Tab previousTab, boolean fromClient) {
            super((Component)source, fromClient);
            this.selectedTab = source.tabs.getSelectedTab();
            this.initialSelection = source.tabs.isAutoselect() && previousTab == null && !fromClient;
            this.previousTab = previousTab;
        }

        public Tab getSelectedTab() {
            return this.selectedTab;
        }

        public Tab getPreviousTab() {
            return this.previousTab;
        }

        public boolean isInitialSelection() {
            return this.initialSelection;
        }
    }
}

