/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.HTMLGenerator;
import com.storedobject.vaadin.HasSize;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.html.Span;
import java.io.Serializable;

public class StyledText
extends Composite<Span>
implements HasText,
HasSize,
HTMLGenerator {
    private final Span content = new Span();
    private String text;

    public StyledText() {
        this(null);
    }

    public StyledText(String htmlText) {
        this.setText(htmlText);
        this.content.getStyle().set("display", "inline");
    }

    protected void onAttach(AttachEvent attachEvent) {
        this.setTextInt(this.text);
        super.onAttach(attachEvent);
    }

    protected Span initContent() {
        return this.content;
    }

    public void setText(String htmlText) {
        this.setTextInt(htmlText);
    }

    private void setTextInt(String htmlText) {
        if (htmlText == null) {
            htmlText = "";
        }
        this.text = htmlText;
        this.content.getElement().executeJs("this.innerHTML = $0", new Serializable[]{htmlText});
    }

    public String getText() {
        return this.text;
    }

    @Override
    public String getHTML() {
        return this.getText();
    }
}

