/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.helper.ID;
import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.streams.DownloadEvent;
import com.vaadin.flow.server.streams.DownloadResponse;
import com.vaadin.flow.server.streams.InputStreamDownloadCallback;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;

public class StreamDownloader
implements InputStreamDownloadCallback {
    private final Supplier<InputStream> streamProvider;
    private final String contentType;
    private String fileName;

    public StreamDownloader(Supplier<InputStream> streamProvider, String contentType) {
        this(streamProvider, contentType, null);
    }

    public StreamDownloader(Supplier<InputStream> streamProvider, String contentType, String fileName) {
        this.streamProvider = streamProvider;
        this.contentType = contentType;
        this.fileName = fileName == null ? "so" + ID.newID() + ".dat" : fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        if (fileName != null) {
            this.fileName = fileName;
        }
    }

    public DownloadResponse complete(DownloadEvent downloadEvent) throws IOException {
        InputStream stream;
        InputStream inputStream = stream = this.streamProvider == null ? null : this.streamProvider.get();
        if (stream == null) {
            return DownloadResponse.error((HttpStatusCode)HttpStatusCode.NOT_FOUND);
        }
        return new DownloadResponse(this.streamProvider.get(), this.getFileName(), this.contentType, -1L);
    }
}

